@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.FleetHubProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.containerservice.kotlin.outputs.FleetHubProfileResponse.Companion.toKotlin as fleetHubProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.azurenative.containerservice.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * The Fleet resource.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15, 2024-02-02-preview, 2024-04-01.
 * ## Example Usage
 * ### Creates a Fleet resource with a long running operation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fleet = new AzureNative.ContainerService.Fleet("fleet", new()
 *     {
 *         FleetName = "fleet1",
 *         HubProfile = new AzureNative.ContainerService.Inputs.FleetHubProfileArgs
 *         {
 *             DnsPrefix = "dnsprefix1",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewFleet(ctx, "fleet", &containerservice.FleetArgs{
 * 			FleetName: pulumi.String("fleet1"),
 * 			HubProfile: &containerservice.FleetHubProfileArgs{
 * 				DnsPrefix: pulumi.String("dnsprefix1"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.Fleet;
 * import com.pulumi.azurenative.containerservice.FleetArgs;
 * import com.pulumi.azurenative.containerservice.inputs.FleetHubProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fleet = new Fleet("fleet", FleetArgs.builder()
 *             .fleetName("fleet1")
 *             .hubProfile(FleetHubProfileArgs.builder()
 *                 .dnsPrefix("dnsprefix1")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:Fleet fleet-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}
 * ```
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The FleetHubProfile configures the Fleet's hub.
     */
    public val hubProfile: Output<FleetHubProfileResponse>?
        get() = javaResource.hubProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    fleetHubProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(
        javaResource as
            com.pulumi.azurenative.containerservice.Fleet,
    )
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
