@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStrategyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStrategyResponse.Companion.toKotlin as updateRunStrategyResponseToKotlin

/**
 * Builder for [FleetUpdateStrategy].
 */
@PulumiTagMarker
public class FleetUpdateStrategyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetUpdateStrategyArgs = FleetUpdateStrategyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetUpdateStrategyArgsBuilder.() -> Unit) {
        val builder = FleetUpdateStrategyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FleetUpdateStrategy {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.FleetUpdateStrategy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FleetUpdateStrategy(builtJavaResource)
    }
}

/**
 * Defines a multi-stage process to perform update operations across members of a Fleet.
 * Azure REST API version: 2023-08-15-preview.
 * Other available API versions: 2023-10-15, 2024-02-02-preview, 2024-04-01.
 * ## Example Usage
 * ### Create a FleetUpdateStrategy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fleetUpdateStrategy = new AzureNative.ContainerService.FleetUpdateStrategy("fleetUpdateStrategy", new()
 *     {
 *         FleetName = "fleet1",
 *         ResourceGroupName = "rg1",
 *         Strategy = new AzureNative.ContainerService.Inputs.UpdateRunStrategyArgs
 *         {
 *             Stages = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.UpdateStageArgs
 *                 {
 *                     AfterStageWaitInSeconds = 3600,
 *                     Groups = new[]
 *                     {
 *                         new AzureNative.ContainerService.Inputs.UpdateGroupArgs
 *                         {
 *                             Name = "group-a",
 *                         },
 *                     },
 *                     Name = "stage1",
 *                 },
 *             },
 *         },
 *         UpdateStrategyName = "strartegy1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewFleetUpdateStrategy(ctx, "fleetUpdateStrategy", &containerservice.FleetUpdateStrategyArgs{
 * 			FleetName:         pulumi.String("fleet1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Strategy: &containerservice.UpdateRunStrategyArgs{
 * 				Stages: containerservice.UpdateStageArray{
 * 					&containerservice.UpdateStageArgs{
 * 						AfterStageWaitInSeconds: pulumi.Int(3600),
 * 						Groups: containerservice.UpdateGroupArray{
 * 							&containerservice.UpdateGroupArgs{
 * 								Name: pulumi.String("group-a"),
 * 							},
 * 						},
 * 						Name: pulumi.String("stage1"),
 * 					},
 * 				},
 * 			},
 * 			UpdateStrategyName: pulumi.String("strartegy1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.FleetUpdateStrategy;
 * import com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs;
 * import com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fleetUpdateStrategy = new FleetUpdateStrategy("fleetUpdateStrategy", FleetUpdateStrategyArgs.builder()
 *             .fleetName("fleet1")
 *             .resourceGroupName("rg1")
 *             .strategy(UpdateRunStrategyArgs.builder()
 *                 .stages(UpdateStageArgs.builder()
 *                     .afterStageWaitInSeconds(3600)
 *                     .groups(UpdateGroupArgs.builder()
 *                         .name("group-a")
 *                         .build())
 *                     .name("stage1")
 *                     .build())
 *                 .build())
 *             .updateStrategyName("strartegy1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:FleetUpdateStrategy strategy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateStrategies/{updateStrategyName}
 * ```
 */
public class FleetUpdateStrategy internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.FleetUpdateStrategy,
) : KotlinCustomResource(javaResource, FleetUpdateStrategyMapper) {
    /**
     * If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the UpdateStrategy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the update sequence of the clusters.
     */
    public val strategy: Output<UpdateRunStrategyResponse>
        get() = javaResource.strategy().applyValue({ args0 ->
            args0.let({ args0 ->
                updateRunStrategyResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FleetUpdateStrategyMapper : ResourceMapper<FleetUpdateStrategy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.FleetUpdateStrategy::class == javaResource::class

    override fun map(javaResource: Resource): FleetUpdateStrategy = FleetUpdateStrategy(
        javaResource
            as com.pulumi.azurenative.containerservice.FleetUpdateStrategy,
    )
}

/**
 * @see [FleetUpdateStrategy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FleetUpdateStrategy].
 */
public suspend fun fleetUpdateStrategy(
    name: String,
    block: suspend FleetUpdateStrategyResourceBuilder.() -> Unit,
): FleetUpdateStrategy {
    val builder = FleetUpdateStrategyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FleetUpdateStrategy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleetUpdateStrategy(name: String): FleetUpdateStrategy {
    val builder = FleetUpdateStrategyResourceBuilder()
    builder.name(name)
    return builder.build()
}
