@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.UpdateRunStrategyArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.UpdateRunStrategyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines a multi-stage process to perform update operations across members of a Fleet.
 * Azure REST API version: 2023-08-15-preview.
 * Other available API versions: 2023-10-15, 2024-02-02-preview, 2024-04-01.
 * ## Example Usage
 * ### Create a FleetUpdateStrategy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fleetUpdateStrategy = new AzureNative.ContainerService.FleetUpdateStrategy("fleetUpdateStrategy", new()
 *     {
 *         FleetName = "fleet1",
 *         ResourceGroupName = "rg1",
 *         Strategy = new AzureNative.ContainerService.Inputs.UpdateRunStrategyArgs
 *         {
 *             Stages = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.UpdateStageArgs
 *                 {
 *                     AfterStageWaitInSeconds = 3600,
 *                     Groups = new[]
 *                     {
 *                         new AzureNative.ContainerService.Inputs.UpdateGroupArgs
 *                         {
 *                             Name = "group-a",
 *                         },
 *                     },
 *                     Name = "stage1",
 *                 },
 *             },
 *         },
 *         UpdateStrategyName = "strartegy1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewFleetUpdateStrategy(ctx, "fleetUpdateStrategy", &containerservice.FleetUpdateStrategyArgs{
 * 			FleetName:         pulumi.String("fleet1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Strategy: &containerservice.UpdateRunStrategyArgs{
 * 				Stages: containerservice.UpdateStageArray{
 * 					&containerservice.UpdateStageArgs{
 * 						AfterStageWaitInSeconds: pulumi.Int(3600),
 * 						Groups: containerservice.UpdateGroupArray{
 * 							&containerservice.UpdateGroupArgs{
 * 								Name: pulumi.String("group-a"),
 * 							},
 * 						},
 * 						Name: pulumi.String("stage1"),
 * 					},
 * 				},
 * 			},
 * 			UpdateStrategyName: pulumi.String("strartegy1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.FleetUpdateStrategy;
 * import com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs;
 * import com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fleetUpdateStrategy = new FleetUpdateStrategy("fleetUpdateStrategy", FleetUpdateStrategyArgs.builder()
 *             .fleetName("fleet1")
 *             .resourceGroupName("rg1")
 *             .strategy(UpdateRunStrategyArgs.builder()
 *                 .stages(UpdateStageArgs.builder()
 *                     .afterStageWaitInSeconds(3600)
 *                     .groups(UpdateGroupArgs.builder()
 *                         .name("group-a")
 *                         .build())
 *                     .name("stage1")
 *                     .build())
 *                 .build())
 *             .updateStrategyName("strartegy1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:FleetUpdateStrategy strategy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateStrategies/{updateStrategyName}
 * ```
 * @property fleetName The name of the Fleet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property strategy Defines the update sequence of the clusters.
 * @property updateStrategyName The name of the UpdateStrategy resource.
 */
public data class FleetUpdateStrategyArgs(
    public val fleetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val strategy: Output<UpdateRunStrategyArgs>? = null,
    public val updateStrategyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs =
        com.pulumi.azurenative.containerservice.FleetUpdateStrategyArgs.builder()
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .strategy(strategy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .updateStrategyName(updateStrategyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetUpdateStrategyArgs].
 */
@PulumiTagMarker
public class FleetUpdateStrategyArgsBuilder internal constructor() {
    private var fleetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var strategy: Output<UpdateRunStrategyArgs>? = null

    private var updateStrategyName: Output<String>? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("rhhojsjvdlcukisk")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gupkxiiqyobidmmd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Defines the update sequence of the clusters.
     */
    @JvmName("emvujtwsmxqsthfs")
    public suspend fun strategy(`value`: Output<UpdateRunStrategyArgs>) {
        this.strategy = value
    }

    /**
     * @param value The name of the UpdateStrategy resource.
     */
    @JvmName("pnhrevjmbjlpebuw")
    public suspend fun updateStrategyName(`value`: Output<String>) {
        this.updateStrategyName = value
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("tuctwclksabtfwce")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ikckboeaxgylgipp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Defines the update sequence of the clusters.
     */
    @JvmName("turlcduvbcescinr")
    public suspend fun strategy(`value`: UpdateRunStrategyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param argument Defines the update sequence of the clusters.
     */
    @JvmName("mewvfglpnlappdws")
    public suspend fun strategy(argument: suspend UpdateRunStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = UpdateRunStrategyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.strategy = mapped
    }

    /**
     * @param value The name of the UpdateStrategy resource.
     */
    @JvmName("iydqrfretfisoblx")
    public suspend fun updateStrategyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateStrategyName = mapped
    }

    internal fun build(): FleetUpdateStrategyArgs = FleetUpdateStrategyArgs(
        fleetName = fleetName,
        resourceGroupName = resourceGroupName,
        strategy = strategy,
        updateStrategyName = updateStrategyName,
    )
}
