@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorResponse.Companion.toKotlin as labelSelectorResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.LoadBalancer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * The configurations regarding multiple standard load balancers. If not supplied, single load balancer mode will be used. Multiple standard load balancers mode will be used if at lease one configuration is supplied. There has to be a configuration named `kubernetes`.
 * Azure REST API version: 2024-03-02-preview.
 * ## Example Usage
 * ### Create or update a Load Balancer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.ContainerService.LoadBalancer("loadBalancer", new()
 *     {
 *         AllowServicePlacement = true,
 *         LoadBalancerName = "kubernetes",
 *         Name = "kubernetes",
 *         PrimaryAgentPoolName = "agentpool1",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewLoadBalancer(ctx, "loadBalancer", &containerservice.LoadBalancerArgs{
 * 			AllowServicePlacement: pulumi.Bool(true),
 * 			LoadBalancerName:      pulumi.String("kubernetes"),
 * 			Name:                  pulumi.String("kubernetes"),
 * 			PrimaryAgentPoolName:  pulumi.String("agentpool1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ResourceName:          pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.LoadBalancer;
 * import com.pulumi.azurenative.containerservice.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .allowServicePlacement(true)
 *             .loadBalancerName("kubernetes")
 *             .name("kubernetes")
 *             .primaryAgentPoolName("agentpool1")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:LoadBalancer kubernetes /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/loadBalancers/{loadBalancerName}
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * Whether to automatically place services on the load balancer. If not supplied, the default value is true. If set to false manually, both of the external and the internal load balancer will not be selected for services unless they explicitly target it.
     */
    public val allowServicePlacement: Output<Boolean>?
        get() = javaResource.allowServicePlacement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Nodes that match this selector will be possible members of this load balancer.
     */
    public val nodeSelector: Output<LabelSelectorResponse>?
        get() = javaResource.nodeSelector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    labelSelectorResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Required field. A string value that must specify the ID of an existing agent pool. All nodes in the given pool will always be added to this load balancer. This agent pool must have at least one node and minCount>=1 for autoscaling operations. An agent pool can only be the primary pool for a single load balancer.
     */
    public val primaryAgentPoolName: Output<String>
        get() = javaResource.primaryAgentPoolName().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Only services that must match this selector can be placed on this load balancer.
     */
    public val serviceLabelSelector: Output<LabelSelectorResponse>?
        get() = javaResource.serviceLabelSelector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> labelSelectorResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Services created in namespaces that match the selector can be placed on this load balancer.
     */
    public val serviceNamespaceSelector: Output<LabelSelectorResponse>?
        get() = javaResource.serviceNamespaceSelector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> labelSelectorResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.azurenative.containerservice.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
