@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.LoadBalancerArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.LabelSelectorArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.LabelSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configurations regarding multiple standard load balancers. If not supplied, single load balancer mode will be used. Multiple standard load balancers mode will be used if at lease one configuration is supplied. There has to be a configuration named `kubernetes`.
 * Azure REST API version: 2024-03-02-preview.
 * ## Example Usage
 * ### Create or update a Load Balancer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.ContainerService.LoadBalancer("loadBalancer", new()
 *     {
 *         AllowServicePlacement = true,
 *         LoadBalancerName = "kubernetes",
 *         Name = "kubernetes",
 *         PrimaryAgentPoolName = "agentpool1",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewLoadBalancer(ctx, "loadBalancer", &containerservice.LoadBalancerArgs{
 * 			AllowServicePlacement: pulumi.Bool(true),
 * 			LoadBalancerName:      pulumi.String("kubernetes"),
 * 			Name:                  pulumi.String("kubernetes"),
 * 			PrimaryAgentPoolName:  pulumi.String("agentpool1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ResourceName:          pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.LoadBalancer;
 * import com.pulumi.azurenative.containerservice.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .allowServicePlacement(true)
 *             .loadBalancerName("kubernetes")
 *             .name("kubernetes")
 *             .primaryAgentPoolName("agentpool1")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:LoadBalancer kubernetes /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/loadBalancers/{loadBalancerName}
 * ```
 * @property allowServicePlacement Whether to automatically place services on the load balancer. If not supplied, the default value is true. If set to false manually, both of the external and the internal load balancer will not be selected for services unless they explicitly target it.
 * @property loadBalancerName The name of the load balancer.
 * @property name Name of the public load balancer. There will be an internal load balancer created if needed, and the name will be `<name>-internal`. The internal lb shares the same configurations as the external one. The internal lbs are not needed to be included in LoadBalancer list. There must be a name of kubernetes in the list.
 * @property nodeSelector Nodes that match this selector will be possible members of this load balancer.
 * @property primaryAgentPoolName Required field. A string value that must specify the ID of an existing agent pool. All nodes in the given pool will always be added to this load balancer. This agent pool must have at least one node and minCount>=1 for autoscaling operations. An agent pool can only be the primary pool for a single load balancer.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property serviceLabelSelector Only services that must match this selector can be placed on this load balancer.
 * @property serviceNamespaceSelector Services created in namespaces that match the selector can be placed on this load balancer.
 */
public data class LoadBalancerArgs(
    public val allowServicePlacement: Output<Boolean>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nodeSelector: Output<LabelSelectorArgs>? = null,
    public val primaryAgentPoolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val serviceLabelSelector: Output<LabelSelectorArgs>? = null,
    public val serviceNamespaceSelector: Output<LabelSelectorArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.LoadBalancerArgs =
        com.pulumi.azurenative.containerservice.LoadBalancerArgs.builder()
            .allowServicePlacement(allowServicePlacement?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nodeSelector(nodeSelector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryAgentPoolName(primaryAgentPoolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .serviceLabelSelector(
                serviceLabelSelector?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceNamespaceSelector(
                serviceNamespaceSelector?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var allowServicePlacement: Output<Boolean>? = null

    private var loadBalancerName: Output<String>? = null

    private var name: Output<String>? = null

    private var nodeSelector: Output<LabelSelectorArgs>? = null

    private var primaryAgentPoolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var serviceLabelSelector: Output<LabelSelectorArgs>? = null

    private var serviceNamespaceSelector: Output<LabelSelectorArgs>? = null

    /**
     * @param value Whether to automatically place services on the load balancer. If not supplied, the default value is true. If set to false manually, both of the external and the internal load balancer will not be selected for services unless they explicitly target it.
     */
    @JvmName("yxfumioercvmfuwy")
    public suspend fun allowServicePlacement(`value`: Output<Boolean>) {
        this.allowServicePlacement = value
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("ispijrsmrqlnhlek")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value Name of the public load balancer. There will be an internal load balancer created if needed, and the name will be `<name>-internal`. The internal lb shares the same configurations as the external one. The internal lbs are not needed to be included in LoadBalancer list. There must be a name of kubernetes in the list.
     */
    @JvmName("xciqhgvipmoijhtv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nodes that match this selector will be possible members of this load balancer.
     */
    @JvmName("ytaynnxthkaburvw")
    public suspend fun nodeSelector(`value`: Output<LabelSelectorArgs>) {
        this.nodeSelector = value
    }

    /**
     * @param value Required field. A string value that must specify the ID of an existing agent pool. All nodes in the given pool will always be added to this load balancer. This agent pool must have at least one node and minCount>=1 for autoscaling operations. An agent pool can only be the primary pool for a single load balancer.
     */
    @JvmName("tdflahaiovugfgir")
    public suspend fun primaryAgentPoolName(`value`: Output<String>) {
        this.primaryAgentPoolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wkcsphdeovckglpo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("umvnymxcdvcdsyty")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Only services that must match this selector can be placed on this load balancer.
     */
    @JvmName("iqbcmuwtomyhubdd")
    public suspend fun serviceLabelSelector(`value`: Output<LabelSelectorArgs>) {
        this.serviceLabelSelector = value
    }

    /**
     * @param value Services created in namespaces that match the selector can be placed on this load balancer.
     */
    @JvmName("rhydepqwlxnobsrx")
    public suspend fun serviceNamespaceSelector(`value`: Output<LabelSelectorArgs>) {
        this.serviceNamespaceSelector = value
    }

    /**
     * @param value Whether to automatically place services on the load balancer. If not supplied, the default value is true. If set to false manually, both of the external and the internal load balancer will not be selected for services unless they explicitly target it.
     */
    @JvmName("qdeuxivbiyircbgp")
    public suspend fun allowServicePlacement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowServicePlacement = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("doawjopkmiydgawq")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value Name of the public load balancer. There will be an internal load balancer created if needed, and the name will be `<name>-internal`. The internal lb shares the same configurations as the external one. The internal lbs are not needed to be included in LoadBalancer list. There must be a name of kubernetes in the list.
     */
    @JvmName("svbiqmfpiimftvtm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nodes that match this selector will be possible members of this load balancer.
     */
    @JvmName("nrwvklviaxyrbprc")
    public suspend fun nodeSelector(`value`: LabelSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSelector = mapped
    }

    /**
     * @param argument Nodes that match this selector will be possible members of this load balancer.
     */
    @JvmName("tahhkixvudytuucq")
    public suspend fun nodeSelector(argument: suspend LabelSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = LabelSelectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeSelector = mapped
    }

    /**
     * @param value Required field. A string value that must specify the ID of an existing agent pool. All nodes in the given pool will always be added to this load balancer. This agent pool must have at least one node and minCount>=1 for autoscaling operations. An agent pool can only be the primary pool for a single load balancer.
     */
    @JvmName("rhbhjlbljswlthwc")
    public suspend fun primaryAgentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryAgentPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vqhjbvmhoxcjnfox")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("cqypwcnvwqbryhdv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Only services that must match this selector can be placed on this load balancer.
     */
    @JvmName("xgtjlbmagjpxbfrb")
    public suspend fun serviceLabelSelector(`value`: LabelSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLabelSelector = mapped
    }

    /**
     * @param argument Only services that must match this selector can be placed on this load balancer.
     */
    @JvmName("oooalxvtaydxwtrx")
    public suspend fun serviceLabelSelector(argument: suspend LabelSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = LabelSelectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceLabelSelector = mapped
    }

    /**
     * @param value Services created in namespaces that match the selector can be placed on this load balancer.
     */
    @JvmName("geyktyddqlysempx")
    public suspend fun serviceNamespaceSelector(`value`: LabelSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNamespaceSelector = mapped
    }

    /**
     * @param argument Services created in namespaces that match the selector can be placed on this load balancer.
     */
    @JvmName("ajbpsltikghdaoad")
    public suspend fun serviceNamespaceSelector(argument: suspend LabelSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = LabelSelectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceNamespaceSelector = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        allowServicePlacement = allowServicePlacement,
        loadBalancerName = loadBalancerName,
        name = name,
        nodeSelector = nodeSelector,
        primaryAgentPoolName = primaryAgentPoolName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        serviceLabelSelector = serviceLabelSelector,
        serviceNamespaceSelector = serviceNamespaceSelector,
    )
}
