@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.TimeInWeekResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.TimeSpanResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.TimeInWeekResponse.Companion.toKotlin as timeInWeekResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.TimeSpanResponse.Companion.toKotlin as timeSpanResponseToKotlin

/**
 * Builder for [MaintenanceConfiguration].
 */
@PulumiTagMarker
public class MaintenanceConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaintenanceConfigurationArgs = MaintenanceConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaintenanceConfigurationArgsBuilder.() -> Unit) {
        val builder = MaintenanceConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MaintenanceConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.MaintenanceConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MaintenanceConfiguration(builtJavaResource)
    }
}

/**
 * See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview, 2024-01-01, 2024-01-02-preview, 2024-02-01, 2024-02-02-preview, 2024-03-02-preview.
 * ## Example Usage
 * ### Create/Update Maintenance Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var maintenanceConfiguration = new AzureNative.ContainerService.MaintenanceConfiguration("maintenanceConfiguration", new()
 *     {
 *         ConfigName = "default",
 *         NotAllowedTime = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.TimeSpanArgs
 *             {
 *                 End = "2020-11-30T12:00:00Z",
 *                 Start = "2020-11-26T03:00:00Z",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         TimeInWeek = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.TimeInWeekArgs
 *             {
 *                 Day = AzureNative.ContainerService.WeekDay.Monday,
 *                 HourSlots = new[]
 *                 {
 *                     1,
 *                     2,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewMaintenanceConfiguration(ctx, "maintenanceConfiguration", &containerservice.MaintenanceConfigurationArgs{
 * 			ConfigName: pulumi.String("default"),
 * 			NotAllowedTime: containerservice.TimeSpanArray{
 * 				&containerservice.TimeSpanArgs{
 * 					End:   pulumi.String("2020-11-30T12:00:00Z"),
 * 					Start: pulumi.String("2020-11-26T03:00:00Z"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			TimeInWeek: containerservice.TimeInWeekArray{
 * 				&containerservice.TimeInWeekArgs{
 * 					Day: pulumi.String(containerservice.WeekDayMonday),
 * 					HourSlots: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 						pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.MaintenanceConfiguration;
 * import com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.TimeSpanArgs;
 * import com.pulumi.azurenative.containerservice.inputs.TimeInWeekArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var maintenanceConfiguration = new MaintenanceConfiguration("maintenanceConfiguration", MaintenanceConfigurationArgs.builder()
 *             .configName("default")
 *             .notAllowedTime(TimeSpanArgs.builder()
 *                 .end("2020-11-30T12:00:00Z")
 *                 .start("2020-11-26T03:00:00Z")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .timeInWeek(TimeInWeekArgs.builder()
 *                 .day("Monday")
 *                 .hourSlots(
 *                     1,
 *                     2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:MaintenanceConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/maintenanceConfigurations/{configName}
 * ```
 */
public class MaintenanceConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.MaintenanceConfiguration,
) : KotlinCustomResource(javaResource, MaintenanceConfigurationMapper) {
    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Time slots on which upgrade is not allowed.
     */
    public val notAllowedTime: Output<List<TimeSpanResponse>>?
        get() = javaResource.notAllowedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> timeSpanResponseToKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    public val timeInWeek: Output<List<TimeInWeekResponse>>?
        get() = javaResource.timeInWeek().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> timeInWeekResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MaintenanceConfigurationMapper : ResourceMapper<MaintenanceConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.MaintenanceConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): MaintenanceConfiguration =
        MaintenanceConfiguration(
            javaResource as
                com.pulumi.azurenative.containerservice.MaintenanceConfiguration,
        )
}

/**
 * @see [MaintenanceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaintenanceConfiguration].
 */
public suspend fun maintenanceConfiguration(
    name: String,
    block: suspend MaintenanceConfigurationResourceBuilder.() -> Unit,
): MaintenanceConfiguration {
    val builder = MaintenanceConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaintenanceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maintenanceConfiguration(name: String): MaintenanceConfiguration {
    val builder = MaintenanceConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
