@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.ManagedClusterArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.KubernetesSupportPlan
import com.pulumi.azurenative.containerservice.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceLinuxProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceLinuxProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceNetworkProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceNetworkProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAADProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAADProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAPIServerAccessProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAPIServerAccessProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAddonProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAddonProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAgentPoolProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAgentPoolProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAutoUpgradeProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAutoUpgradeProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAzureMonitorProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAzureMonitorProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterHTTPProxyConfigArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterHTTPProxyConfigArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterIdentityArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterIdentityArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterOIDCIssuerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterOIDCIssuerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPodIdentityProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPodIdentityProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPropertiesAutoScalerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPropertiesAutoScalerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSKUArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSKUArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSecurityProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSecurityProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterServicePrincipalProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterServicePrincipalProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterStorageProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterStorageProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWindowsProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWindowsProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWorkloadAutoScalerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWorkloadAutoScalerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.PrivateLinkResourceArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.PrivateLinkResourceArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.UserAssignedIdentityArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.UserAssignedIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed cluster.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-08-31, 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview, 2024-01-01, 2024-01-02-preview, 2024-02-01, 2024-02-02-preview, 2024-03-02-preview.
 * When creating a managed cluster you must define at least one agent pool inline via the `agentPoolProfiles` property. The Azure API does not currently allow this property to be updated directly. Instead, additional agent pools can be defined via the `AgentPool` resource. If needing to change the initial agent pool profile property, you can either trigger the whole cluster to be re-created by using the [replaceOnChanges resource option](https://www.pulumi.com/docs/concepts/options/replaceonchanges/), or make the change directly in Azure then use `pulumi refresh` to update the stack's stack to match.
 * ## Example Usage
 * ### Create Managed Cluster using an agent pool snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *                 {
 *                     SourceResourceId = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1",
 *                 },
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count: pulumi.Int(3),
 * 					CreationData: &containerservice.CreationDataArgs{
 * 						SourceResourceId: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
 * 					},
 * 					EnableFIPS:         pulumi.Bool(true),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(false),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.CreationDataArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .creationData(CreationDataArgs.builder()
 *                     .sourceResourceId("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1")
 *                     .build())
 *                 .enableFIPS(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with AKS-managed NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             NatGatewayProfile = new AzureNative.ContainerService.Inputs.ManagedClusterNATGatewayProfileArgs
 *             {
 *                 ManagedOutboundIPProfile = new AzureNative.ContainerService.Inputs.ManagedClusterManagedOutboundIPProfileArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             OutboundType = AzureNative.ContainerService.OutboundType.ManagedNATGateway,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(false),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				NatGatewayProfile: &containerservice.ManagedClusterNATGatewayProfileArgs{
 * 					ManagedOutboundIPProfile: &containerservice.ManagedClusterManagedOutboundIPProfileArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				OutboundType: pulumi.String(containerservice.OutboundTypeManagedNATGateway),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterNATGatewayProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterManagedOutboundIPProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(false)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerSku("standard")
 *                 .natGatewayProfile(ManagedClusterNATGatewayProfileArgs.builder()
 *                     .managedOutboundIPProfile(ManagedClusterManagedOutboundIPProfileArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .outboundType("managedNATGateway")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Azure KeyVault Secrets Provider Addon
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles =
 *         {
 *             { "azureKeyvaultSecretsProvider", new AzureNative.ContainerService.Inputs.ManagedClusterAddonProfileArgs
 *             {
 *                 Config =
 *                 {
 *                     { "enableSecretRotation", "true" },
 *                     { "rotationPollInterval", "2m" },
 *                 },
 *                 Enabled = true,
 *             } },
 *         },
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: containerservice.ManagedClusterAddonProfileMap{
 * 				"azureKeyvaultSecretsProvider": &containerservice.ManagedClusterAddonProfileArgs{
 * 					Config: pulumi.StringMap{
 * 						"enableSecretRotation": pulumi.String("true"),
 * 						"rotationPollInterval": pulumi.String("2m"),
 * 					},
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles(Map.of("azureKeyvaultSecretsProvider", Map.ofEntries(
 *                 Map.entry("config", Map.ofEntries(
 *                     Map.entry("enableSecretRotation", "true"),
 *                     Map.entry("rotationPollInterval", "2m")
 *                 )),
 *                 Map.entry("enabled", true)
 *             )))
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Dedicated Host Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 HostGroupID = "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1",
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					HostGroupID:        pulumi.String("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(false),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .hostGroupID("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with EncryptionAtHost enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                  pulumi.Int(3),
 * 					EnableEncryptionAtHost: pulumi.Bool(true),
 * 					EnableNodePublicIP:     pulumi.Bool(true),
 * 					Mode:                   pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                   pulumi.String("nodepool1"),
 * 					OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                   pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableEncryptionAtHost(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with FIPS enabled OS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableFIPS:         pulumi.Bool(true),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(false),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableFIPS(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with GPUMIG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 GpuInstanceProfile = AzureNative.ContainerService.GPUInstanceProfile.MIG3g,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_ND96asr_v4",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					GpuInstanceProfile: pulumi.String(containerservice.GPUInstanceProfileMIG3g),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_ND96asr_v4"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * 				HttpProxy:  pulumi.String("http://myproxy.server.com:8080"),
 * 				HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * 				NoProxy: pulumi.StringArray{
 * 					pulumi.String("localhost"),
 * 					pulumi.String("127.0.0.1"),
 * 				},
 * 				TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * 			},
 * 			KubernetesVersion: pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .gpuInstanceProfile("MIG3g")
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_ND96asr_v4")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(ManagedClusterHTTPProxyConfigArgs.builder()
 *                 .httpProxy("http://myproxy.server.com:8080")
 *                 .httpsProxy("https://myproxy.server.com:8080")
 *                 .noProxy(
 *                     "localhost",
 *                     "127.0.0.1")
 *                 .trustedCa("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *                 .build())
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with HTTP proxy configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * 				HttpProxy:  pulumi.String("http://myproxy.server.com:8080"),
 * 				HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * 				NoProxy: pulumi.StringArray{
 * 					pulumi.String("localhost"),
 * 					pulumi.String("127.0.0.1"),
 * 				},
 * 				TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * 			},
 * 			KubernetesVersion: pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(ManagedClusterHTTPProxyConfigArgs.builder()
 *                 .httpProxy("http://myproxy.server.com:8080")
 *                 .httpsProxy("https://myproxy.server.com:8080")
 *                 .noProxy(
 *                     "localhost",
 *                     "127.0.0.1")
 *                 .trustedCa("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *                 .build())
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with LongTermSupport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = AzureNative.ContainerService.ManagedClusterSKUName.Base,
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Premium,
 *         },
 *         SupportPlan = AzureNative.ContainerService.KubernetesSupportPlan.AKSLongTermSupport,
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                  pulumi.Int(3),
 * 					EnableEncryptionAtHost: pulumi.Bool(true),
 * 					EnableNodePublicIP:     pulumi.Bool(true),
 * 					Mode:                   pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                   pulumi.String("nodepool1"),
 * 					OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                   pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * 				DisableRunCommand: pulumi.Bool(true),
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String(containerservice.ManagedClusterSKUNameBase),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierPremium),
 * 			},
 * 			SupportPlan: pulumi.String(containerservice.KubernetesSupportPlanAKSLongTermSupport),
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableEncryptionAtHost(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .apiServerAccessProfile(ManagedClusterAPIServerAccessProfileArgs.builder()
 *                 .disableRunCommand(true)
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Base")
 *                 .tier("Premium")
 *                 .build())
 *             .supportPlan("AKSLongTermSupport")
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Node Public IP Prefix
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 NodePublicIPPrefixID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                pulumi.Int(3),
 * 					EnableNodePublicIP:   pulumi.Bool(true),
 * 					Mode:                 pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                 pulumi.String("nodepool1"),
 * 					NodePublicIPPrefixID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
 * 					OsType:               pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                 pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:               pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .nodePublicIPPrefixID("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsSKU = AzureNative.ContainerService.OSSKU.AzureLinux,
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsSKU:              pulumi.String(containerservice.OSSKUAzureLinux),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * 				HttpProxy:  pulumi.String("http://myproxy.server.com:8080"),
 * 				HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * 				NoProxy: pulumi.StringArray{
 * 					pulumi.String("localhost"),
 * 					pulumi.String("127.0.0.1"),
 * 				},
 * 				TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * 			},
 * 			KubernetesVersion: pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osSKU("AzureLinux")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(ManagedClusterHTTPProxyConfigArgs.builder()
 *                 .httpProxy("http://myproxy.server.com:8080")
 *                 .httpsProxy("https://myproxy.server.com:8080")
 *                 .noProxy(
 *                     "localhost",
 *                     "127.0.0.1")
 *                 .trustedCa("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *                 .build())
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PPG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 ProximityPlacementGroupID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1",
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                     pulumi.Int(3),
 * 					EnableNodePublicIP:        pulumi.Bool(true),
 * 					Mode:                      pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                      pulumi.String("nodepool1"),
 * 					OsType:                    pulumi.String(containerservice.OSTypeLinux),
 * 					ProximityPlacementGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 * 					Type:                      pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                    pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .proximityPlacementGroupID("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PodIdentity enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         PodIdentityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPodIdentityProfileArgs
 *         {
 *             AllowNetworkPluginKubenet = true,
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			PodIdentityProfile: &containerservice.ManagedClusterPodIdentityProfileArgs{
 * 				AllowNetworkPluginKubenet: pulumi.Bool(true),
 * 				Enabled:                   pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .podIdentityProfile(ManagedClusterPodIdentityProfileArgs.builder()
 *                 .allowNetworkPluginKubenet(true)
 *                 .enabled(true)
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with RunCommand disabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                  pulumi.Int(3),
 * 					EnableEncryptionAtHost: pulumi.Bool(true),
 * 					EnableNodePublicIP:     pulumi.Bool(true),
 * 					Mode:                   pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                   pulumi.String("nodepool1"),
 * 					OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                   pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * 				DisableRunCommand: pulumi.Bool(true),
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableEncryptionAtHost(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .apiServerAccessProfile(ManagedClusterAPIServerAccessProfileArgs.builder()
 *                 .disableRunCommand(true)
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Security Profile configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         SecurityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileArgs
 *         {
 *             Defender = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderArgs
 *             {
 *                 LogAnalyticsWorkspaceResourceId = "/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME",
 *                 SecurityMonitoring = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *             WorkloadIdentity = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs
 *             {
 *                 Enabled = true,
 *             },
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			DnsPrefix:         pulumi.String("dnsprefix1"),
 * 			KubernetesVersion: pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			SecurityProfile: &containerservice.ManagedClusterSecurityProfileArgs{
 * 				Defender: &containerservice.ManagedClusterSecurityProfileDefenderArgs{
 * 					LogAnalyticsWorkspaceResourceId: pulumi.String("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
 * 					SecurityMonitoring: &containerservice.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 				WorkloadIdentity: &containerservice.ManagedClusterSecurityProfileWorkloadIdentityArgs{
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .dnsPrefix("dnsprefix1")
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .securityProfile(ManagedClusterSecurityProfileArgs.builder()
 *                 .defender(ManagedClusterSecurityProfileDefenderArgs.builder()
 *                     .logAnalyticsWorkspaceResourceId("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME")
 *                     .securityMonitoring(ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .workloadIdentity(ManagedClusterSecurityProfileWorkloadIdentityArgs.builder()
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with UltraSSD enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 EnableUltraSSD = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					EnableUltraSSD:     pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .enableUltraSSD(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with user-assigned NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.UserAssignedNATGateway,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(false),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeUserAssignedNATGateway),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableNodePublicIP(false)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerSku("standard")
 *                 .outboundType("userAssignedNATGateway")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with Public FQDN specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             EnablePrivateClusterPublicFQDN = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                  pulumi.Int(3),
 * 					EnableEncryptionAtHost: pulumi.Bool(true),
 * 					EnableNodePublicIP:     pulumi.Bool(true),
 * 					Mode:                   pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                   pulumi.String("nodepool1"),
 * 					OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                   pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * 				EnablePrivateCluster:           pulumi.Bool(true),
 * 				EnablePrivateClusterPublicFQDN: pulumi.Bool(true),
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableEncryptionAtHost(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .apiServerAccessProfile(ManagedClusterAPIServerAccessProfileArgs.builder()
 *                 .enablePrivateCluster(true)
 *                 .enablePrivateClusterPublicFQDN(true)
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with fqdn subdomain specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             PrivateDNSZone = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io",
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         FqdnSubdomain = "domain1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					Count:                  pulumi.Int(3),
 * 					EnableEncryptionAtHost: pulumi.Bool(true),
 * 					EnableNodePublicIP:     pulumi.Bool(true),
 * 					Mode:                   pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:                   pulumi.String("nodepool1"),
 * 					OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 					Type:                   pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 				},
 * 			},
 * 			ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * 				EnablePrivateCluster: pulumi.Bool(true),
 * 				PrivateDNSZone:       pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io"),
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			FqdnSubdomain:           pulumi.String("domain1"),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .count(3)
 *                 .enableEncryptionAtHost(true)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS2_v2")
 *                 .build())
 *             .apiServerAccessProfile(ManagedClusterAPIServerAccessProfileArgs.builder()
 *                 .enablePrivateCluster(true)
 *                 .privateDNSZone("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .fqdnSubdomain("domain1")
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update AAD Managed Cluster with EnableAzureRBAC
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AadProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAADProfileArgs
 *         {
 *             EnableAzureRBAC = true,
 *             Managed = true,
 *         },
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = AzureNative.ContainerService.AgentPoolMode.System,
 *                 Name = "nodepool1",
 *                 OsType = AzureNative.ContainerService.OSType.Linux,
 *                 Type = AzureNative.ContainerService.AgentPoolType.VirtualMachineScaleSets,
 *                 VmSize = "Standard_DS1_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = AzureNative.ContainerService.LoadBalancerSku.Standard,
 *             OutboundType = AzureNative.ContainerService.OutboundType.LoadBalancer,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = AzureNative.ContainerService.ManagedClusterSKUTier.Free,
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * 			AadProfile: &containerservice.ManagedClusterAADProfileArgs{
 * 				EnableAzureRBAC: pulumi.Bool(true),
 * 				Managed:         pulumi.Bool(true),
 * 			},
 * 			AddonProfiles: nil,
 * 			AgentPoolProfiles: containerservice.ManagedClusterAgentPoolProfileArray{
 * 				&containerservice.ManagedClusterAgentPoolProfileArgs{
 * 					AvailabilityZones: pulumi.StringArray{
 * 						pulumi.String("1"),
 * 						pulumi.String("2"),
 * 						pulumi.String("3"),
 * 					},
 * 					Count:              pulumi.Int(3),
 * 					EnableNodePublicIP: pulumi.Bool(true),
 * 					Mode:               pulumi.String(containerservice.AgentPoolModeSystem),
 * 					Name:               pulumi.String("nodepool1"),
 * 					OsType:             pulumi.String(containerservice.OSTypeLinux),
 * 					Type:               pulumi.String(containerservice.AgentPoolTypeVirtualMachineScaleSets),
 * 					VmSize:             pulumi.String("Standard_DS1_v2"),
 * 				},
 * 			},
 * 			AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * 				ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * 				ScanInterval:           pulumi.String("20s"),
 * 			},
 * 			DiskEncryptionSetID:     pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * 			DnsPrefix:               pulumi.String("dnsprefix1"),
 * 			EnablePodSecurityPolicy: pulumi.Bool(true),
 * 			EnableRBAC:              pulumi.Bool(true),
 * 			KubernetesVersion:       pulumi.String(""),
 * 			LinuxProfile: &containerservice.ContainerServiceLinuxProfileArgs{
 * 				AdminUsername: pulumi.String("azureuser"),
 * 				Ssh: &containerservice.ContainerServiceSshConfigurationArgs{
 * 					PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * 						&containerservice.ContainerServiceSshPublicKeyArgs{
 * 							KeyData: pulumi.String("keydata"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * 				LoadBalancerProfile: &containerservice.ManagedClusterLoadBalancerProfileArgs{
 * 					ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * 						Count: pulumi.Int(2),
 * 					},
 * 				},
 * 				LoadBalancerSku: pulumi.String(containerservice.LoadBalancerSkuStandard),
 * 				OutboundType:    pulumi.String(containerservice.OutboundTypeLoadBalancer),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * 				ClientId: pulumi.String("clientid"),
 * 				Secret:   pulumi.String("secret"),
 * 			},
 * 			Sku: &containerservice.ManagedClusterSKUArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String(containerservice.ManagedClusterSKUTierFree),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 			WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * 				AdminPassword: pulumi.String("replacePassword1234$"),
 * 				AdminUsername: pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAADProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAgentPoolProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs;
 * import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .aadProfile(ManagedClusterAADProfileArgs.builder()
 *                 .enableAzureRBAC(true)
 *                 .managed(true)
 *                 .build())
 *             .addonProfiles()
 *             .agentPoolProfiles(ManagedClusterAgentPoolProfileArgs.builder()
 *                 .availabilityZones(
 *                     "1",
 *                     "2",
 *                     "3")
 *                 .count(3)
 *                 .enableNodePublicIP(true)
 *                 .mode("System")
 *                 .name("nodepool1")
 *                 .osType("Linux")
 *                 .type("VirtualMachineScaleSets")
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .autoScalerProfile(ManagedClusterPropertiesAutoScalerProfileArgs.builder()
 *                 .scaleDownDelayAfterAdd("15m")
 *                 .scanInterval("20s")
 *                 .build())
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(ContainerServiceLinuxProfileArgs.builder()
 *                 .adminUsername("azureuser")
 *                 .ssh(ContainerServiceSshConfigurationArgs.builder()
 *                     .publicKeys(ContainerServiceSshPublicKeyArgs.builder()
 *                         .keyData("keydata")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("location1")
 *             .networkProfile(ContainerServiceNetworkProfileArgs.builder()
 *                 .loadBalancerProfile(ManagedClusterLoadBalancerProfileArgs.builder()
 *                     .managedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
 *                         .count(2)
 *                         .build())
 *                     .build())
 *                 .loadBalancerSku("standard")
 *                 .outboundType("loadBalancer")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(ManagedClusterServicePrincipalProfileArgs.builder()
 *                 .clientId("clientid")
 *                 .secret("secret")
 *                 .build())
 *             .sku(ManagedClusterSKUArgs.builder()
 *                 .name("Basic")
 *                 .tier("Free")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(ManagedClusterWindowsProfileArgs.builder()
 *                 .adminPassword("replacePassword1234$")
 *                 .adminUsername("azureuser")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:ManagedCluster clustername1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}
 * ```
 * @property aadProfile The Azure Active Directory configuration.
 * @property addonProfiles The profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pool properties.
 * @property apiServerAccessProfile The access profile for managed cluster API server.
 * @property autoScalerProfile Parameters to be applied to the cluster-autoscaler when enabled
 * @property autoUpgradeProfile The auto upgrade configuration.
 * @property azureMonitorProfile Azure Monitor addon profiles for monitoring the managed cluster.
 * @property disableLocalAccounts If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
 * @property diskEncryptionSetID This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
 * @property dnsPrefix This cannot be updated once the Managed Cluster has been created.
 * @property enablePodSecurityPolicy (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
 * @property enableRBAC Whether to enable Kubernetes Role-Based Access Control.
 * @property extendedLocation The extended location of the Virtual Machine.
 * @property fqdnSubdomain This cannot be updated once the Managed Cluster has been created.
 * @property httpProxyConfig Configurations for provisioning the cluster with HTTP proxy servers.
 * @property identity The identity of the managed cluster, if configured.
 * @property identityProfile Identities associated with the cluster.
 * @property kubernetesVersion Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
 * @property linuxProfile The profile for Linux VMs in the Managed Cluster.
 * @property location The geo-location where the resource lives
 * @property networkProfile The network configuration profile.
 * @property nodeResourceGroup The name of the resource group containing agent pool nodes.
 * @property oidcIssuerProfile The OIDC issuer profile of the Managed Cluster.
 * @property podIdentityProfile See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
 * @property privateLinkResources Private link resources associated with the cluster.
 * @property publicNetworkAccess Allow or deny public network access for AKS
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property securityProfile Security profile for the managed cluster.
 * @property servicePrincipalProfile Information about a service principal identity for the cluster to use for manipulating Azure APIs.
 * @property sku The managed cluster SKU.
 * @property storageProfile Storage profile for the managed cluster.
 * @property supportPlan The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
 * @property tags Resource tags.
 * @property windowsProfile The profile for Windows VMs in the Managed Cluster.
 * @property workloadAutoScalerProfile Workload Auto-scaler profile for the managed cluster.
 */
public data class ManagedClusterArgs(
    public val aadProfile: Output<ManagedClusterAADProfileArgs>? = null,
    public val addonProfiles: Output<Map<String, ManagedClusterAddonProfileArgs>>? = null,
    public val agentPoolProfiles: Output<List<ManagedClusterAgentPoolProfileArgs>>? = null,
    public val apiServerAccessProfile: Output<ManagedClusterAPIServerAccessProfileArgs>? = null,
    public val autoScalerProfile: Output<ManagedClusterPropertiesAutoScalerProfileArgs>? = null,
    public val autoUpgradeProfile: Output<ManagedClusterAutoUpgradeProfileArgs>? = null,
    public val azureMonitorProfile: Output<ManagedClusterAzureMonitorProfileArgs>? = null,
    public val disableLocalAccounts: Output<Boolean>? = null,
    public val diskEncryptionSetID: Output<String>? = null,
    public val dnsPrefix: Output<String>? = null,
    public val enablePodSecurityPolicy: Output<Boolean>? = null,
    public val enableRBAC: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdnSubdomain: Output<String>? = null,
    public val httpProxyConfig: Output<ManagedClusterHTTPProxyConfigArgs>? = null,
    public val identity: Output<ManagedClusterIdentityArgs>? = null,
    public val identityProfile: Output<Map<String, UserAssignedIdentityArgs>>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val linuxProfile: Output<ContainerServiceLinuxProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<ContainerServiceNetworkProfileArgs>? = null,
    public val nodeResourceGroup: Output<String>? = null,
    public val oidcIssuerProfile: Output<ManagedClusterOIDCIssuerProfileArgs>? = null,
    public val podIdentityProfile: Output<ManagedClusterPodIdentityProfileArgs>? = null,
    public val privateLinkResources: Output<List<PrivateLinkResourceArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val securityProfile: Output<ManagedClusterSecurityProfileArgs>? = null,
    public val servicePrincipalProfile: Output<ManagedClusterServicePrincipalProfileArgs>? = null,
    public val sku: Output<ManagedClusterSKUArgs>? = null,
    public val storageProfile: Output<ManagedClusterStorageProfileArgs>? = null,
    public val supportPlan: Output<Either<String, KubernetesSupportPlan>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val windowsProfile: Output<ManagedClusterWindowsProfileArgs>? = null,
    public val workloadAutoScalerProfile: Output<ManagedClusterWorkloadAutoScalerProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.ManagedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.ManagedClusterArgs =
        com.pulumi.azurenative.containerservice.ManagedClusterArgs.builder()
            .aadProfile(aadProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .addonProfiles(
                addonProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .agentPoolProfiles(
                agentPoolProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .apiServerAccessProfile(
                apiServerAccessProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoScalerProfile(autoScalerProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoUpgradeProfile(
                autoUpgradeProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .azureMonitorProfile(
                azureMonitorProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disableLocalAccounts(disableLocalAccounts?.applyValue({ args0 -> args0 }))
            .diskEncryptionSetID(diskEncryptionSetID?.applyValue({ args0 -> args0 }))
            .dnsPrefix(dnsPrefix?.applyValue({ args0 -> args0 }))
            .enablePodSecurityPolicy(enablePodSecurityPolicy?.applyValue({ args0 -> args0 }))
            .enableRBAC(enableRBAC?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdnSubdomain(fqdnSubdomain?.applyValue({ args0 -> args0 }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityProfile(
                identityProfile?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .linuxProfile(linuxProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeResourceGroup(nodeResourceGroup?.applyValue({ args0 -> args0 }))
            .oidcIssuerProfile(oidcIssuerProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .podIdentityProfile(
                podIdentityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateLinkResources(
                privateLinkResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .servicePrincipalProfile(
                servicePrincipalProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportPlan(
                supportPlan?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .windowsProfile(windowsProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadAutoScalerProfile(
                workloadAutoScalerProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterArgs].
 */
@PulumiTagMarker
public class ManagedClusterArgsBuilder internal constructor() {
    private var aadProfile: Output<ManagedClusterAADProfileArgs>? = null

    private var addonProfiles: Output<Map<String, ManagedClusterAddonProfileArgs>>? = null

    private var agentPoolProfiles: Output<List<ManagedClusterAgentPoolProfileArgs>>? = null

    private var apiServerAccessProfile: Output<ManagedClusterAPIServerAccessProfileArgs>? = null

    private var autoScalerProfile: Output<ManagedClusterPropertiesAutoScalerProfileArgs>? = null

    private var autoUpgradeProfile: Output<ManagedClusterAutoUpgradeProfileArgs>? = null

    private var azureMonitorProfile: Output<ManagedClusterAzureMonitorProfileArgs>? = null

    private var disableLocalAccounts: Output<Boolean>? = null

    private var diskEncryptionSetID: Output<String>? = null

    private var dnsPrefix: Output<String>? = null

    private var enablePodSecurityPolicy: Output<Boolean>? = null

    private var enableRBAC: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdnSubdomain: Output<String>? = null

    private var httpProxyConfig: Output<ManagedClusterHTTPProxyConfigArgs>? = null

    private var identity: Output<ManagedClusterIdentityArgs>? = null

    private var identityProfile: Output<Map<String, UserAssignedIdentityArgs>>? = null

    private var kubernetesVersion: Output<String>? = null

    private var linuxProfile: Output<ContainerServiceLinuxProfileArgs>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<ContainerServiceNetworkProfileArgs>? = null

    private var nodeResourceGroup: Output<String>? = null

    private var oidcIssuerProfile: Output<ManagedClusterOIDCIssuerProfileArgs>? = null

    private var podIdentityProfile: Output<ManagedClusterPodIdentityProfileArgs>? = null

    private var privateLinkResources: Output<List<PrivateLinkResourceArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var securityProfile: Output<ManagedClusterSecurityProfileArgs>? = null

    private var servicePrincipalProfile: Output<ManagedClusterServicePrincipalProfileArgs>? = null

    private var sku: Output<ManagedClusterSKUArgs>? = null

    private var storageProfile: Output<ManagedClusterStorageProfileArgs>? = null

    private var supportPlan: Output<Either<String, KubernetesSupportPlan>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var windowsProfile: Output<ManagedClusterWindowsProfileArgs>? = null

    private var workloadAutoScalerProfile: Output<ManagedClusterWorkloadAutoScalerProfileArgs>? = null

    /**
     * @param value The Azure Active Directory configuration.
     */
    @JvmName("gpwproebosfysaih")
    public suspend fun aadProfile(`value`: Output<ManagedClusterAADProfileArgs>) {
        this.aadProfile = value
    }

    /**
     * @param value The profile of managed cluster add-on.
     */
    @JvmName("ydamjxjlhdefrqfy")
    public suspend fun addonProfiles(`value`: Output<Map<String, ManagedClusterAddonProfileArgs>>) {
        this.addonProfiles = value
    }

    /**
     * @param value The agent pool properties.
     */
    @JvmName("dbapnrucxbhktkht")
    public suspend fun agentPoolProfiles(`value`: Output<List<ManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = value
    }

    @JvmName("hurmhllucfebjcdb")
    public suspend fun agentPoolProfiles(vararg values: Output<ManagedClusterAgentPoolProfileArgs>) {
        this.agentPoolProfiles = Output.all(values.asList())
    }

    /**
     * @param values The agent pool properties.
     */
    @JvmName("kljsvhojrppmylme")
    public suspend fun agentPoolProfiles(values: List<Output<ManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = Output.all(values)
    }

    /**
     * @param value The access profile for managed cluster API server.
     */
    @JvmName("vqdgpwlmvnxomvnq")
    public suspend fun apiServerAccessProfile(`value`: Output<ManagedClusterAPIServerAccessProfileArgs>) {
        this.apiServerAccessProfile = value
    }

    /**
     * @param value Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("qlvpyvpwxqdqmpiv")
    public suspend fun autoScalerProfile(`value`: Output<ManagedClusterPropertiesAutoScalerProfileArgs>) {
        this.autoScalerProfile = value
    }

    /**
     * @param value The auto upgrade configuration.
     */
    @JvmName("fldljvbyjsqptfft")
    public suspend fun autoUpgradeProfile(`value`: Output<ManagedClusterAutoUpgradeProfileArgs>) {
        this.autoUpgradeProfile = value
    }

    /**
     * @param value Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("ogcajafdeolphlro")
    public suspend fun azureMonitorProfile(`value`: Output<ManagedClusterAzureMonitorProfileArgs>) {
        this.azureMonitorProfile = value
    }

    /**
     * @param value If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    @JvmName("qwpnvrcpqkxruqxq")
    public suspend fun disableLocalAccounts(`value`: Output<Boolean>) {
        this.disableLocalAccounts = value
    }

    /**
     * @param value This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    @JvmName("hhuxpmvwoceqdlvu")
    public suspend fun diskEncryptionSetID(`value`: Output<String>) {
        this.diskEncryptionSetID = value
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("fppbmalxjgmejpbn")
    public suspend fun dnsPrefix(`value`: Output<String>) {
        this.dnsPrefix = value
    }

    /**
     * @param value (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     */
    @JvmName("kmpadiqvuekpaygw")
    public suspend fun enablePodSecurityPolicy(`value`: Output<Boolean>) {
        this.enablePodSecurityPolicy = value
    }

    /**
     * @param value Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("idefqvikjemoyvxo")
    public suspend fun enableRBAC(`value`: Output<Boolean>) {
        this.enableRBAC = value
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("qnorwmgsftnvgcdq")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("nofpoyrjbnjxvlou")
    public suspend fun fqdnSubdomain(`value`: Output<String>) {
        this.fqdnSubdomain = value
    }

    /**
     * @param value Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("bxqlkqxnqtbrbatn")
    public suspend fun httpProxyConfig(`value`: Output<ManagedClusterHTTPProxyConfigArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value The identity of the managed cluster, if configured.
     */
    @JvmName("ykshmgqhgcaqhjel")
    public suspend fun identity(`value`: Output<ManagedClusterIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Identities associated with the cluster.
     */
    @JvmName("hghihjhlhsaseskl")
    public suspend fun identityProfile(`value`: Output<Map<String, UserAssignedIdentityArgs>>) {
        this.identityProfile = value
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    @JvmName("cyyulqiosklgmsny")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("fhtiqeptuefxtdao")
    public suspend fun linuxProfile(`value`: Output<ContainerServiceLinuxProfileArgs>) {
        this.linuxProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gusdrehtkfclwqdu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network configuration profile.
     */
    @JvmName("olhwqjxseoydbmev")
    public suspend fun networkProfile(`value`: Output<ContainerServiceNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The name of the resource group containing agent pool nodes.
     */
    @JvmName("cevjqdnxlocfxodl")
    public suspend fun nodeResourceGroup(`value`: Output<String>) {
        this.nodeResourceGroup = value
    }

    /**
     * @param value The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("rognqmtiyfxenjoj")
    public suspend fun oidcIssuerProfile(`value`: Output<ManagedClusterOIDCIssuerProfileArgs>) {
        this.oidcIssuerProfile = value
    }

    /**
     * @param value See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("kvcqkttgfgvpqjbw")
    public suspend fun podIdentityProfile(`value`: Output<ManagedClusterPodIdentityProfileArgs>) {
        this.podIdentityProfile = value
    }

    /**
     * @param value Private link resources associated with the cluster.
     */
    @JvmName("ypknvonvdlgplvsi")
    public suspend fun privateLinkResources(`value`: Output<List<PrivateLinkResourceArgs>>) {
        this.privateLinkResources = value
    }

    @JvmName("qtutlptxskrxvkuo")
    public suspend fun privateLinkResources(vararg values: Output<PrivateLinkResourceArgs>) {
        this.privateLinkResources = Output.all(values.asList())
    }

    /**
     * @param values Private link resources associated with the cluster.
     */
    @JvmName("owbrycidniqograv")
    public suspend fun privateLinkResources(values: List<Output<PrivateLinkResourceArgs>>) {
        this.privateLinkResources = Output.all(values)
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("vdhscslvpdtxxwhb")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kexslyoxuaocflmj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("mbcgbstmmusuohak")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Security profile for the managed cluster.
     */
    @JvmName("unppxkswgjxinfij")
    public suspend fun securityProfile(`value`: Output<ManagedClusterSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("wunaryonjvcdumfh")
    public suspend fun servicePrincipalProfile(`value`: Output<ManagedClusterServicePrincipalProfileArgs>) {
        this.servicePrincipalProfile = value
    }

    /**
     * @param value The managed cluster SKU.
     */
    @JvmName("fsvsvbhqsxigmrer")
    public suspend fun sku(`value`: Output<ManagedClusterSKUArgs>) {
        this.sku = value
    }

    /**
     * @param value Storage profile for the managed cluster.
     */
    @JvmName("pnhpryfmyuntipbh")
    public suspend fun storageProfile(`value`: Output<ManagedClusterStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("xiyqrrdtllsjdcul")
    public suspend fun supportPlan(`value`: Output<Either<String, KubernetesSupportPlan>>) {
        this.supportPlan = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qtlhwpltuiimcsgv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("oucrpxfvofadvsyr")
    public suspend fun windowsProfile(`value`: Output<ManagedClusterWindowsProfileArgs>) {
        this.windowsProfile = value
    }

    /**
     * @param value Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("gpcnxoyvquniauhh")
    public suspend fun workloadAutoScalerProfile(`value`: Output<ManagedClusterWorkloadAutoScalerProfileArgs>) {
        this.workloadAutoScalerProfile = value
    }

    /**
     * @param value The Azure Active Directory configuration.
     */
    @JvmName("dtvckcmjxklnxbif")
    public suspend fun aadProfile(`value`: ManagedClusterAADProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadProfile = mapped
    }

    /**
     * @param argument The Azure Active Directory configuration.
     */
    @JvmName("kyxfmusggcmsapvj")
    public suspend fun aadProfile(argument: suspend ManagedClusterAADProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAADProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadProfile = mapped
    }

    /**
     * @param value The profile of managed cluster add-on.
     */
    @JvmName("qpompxkyeqfpnkpn")
    public suspend fun addonProfiles(`value`: Map<String, ManagedClusterAddonProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param argument The profile of managed cluster add-on.
     */
    @JvmName("ammulqcqcifcprwl")
    public suspend fun addonProfiles(vararg argument: Pair<String, suspend ManagedClusterAddonProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ManagedClusterAddonProfileArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.addonProfiles = mapped
    }

    /**
     * @param values The profile of managed cluster add-on.
     */
    @JvmName("kgvhwidbwwfiwwxn")
    public fun addonProfiles(vararg values: Pair<String, ManagedClusterAddonProfileArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param value The agent pool properties.
     */
    @JvmName("dlgylkiufsayxfbc")
    public suspend fun agentPoolProfiles(`value`: List<ManagedClusterAgentPoolProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("ecfmprputahbhuog")
    public suspend fun agentPoolProfiles(argument: List<suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("hspvlekedrembumc")
    public suspend fun agentPoolProfiles(vararg argument: suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("kieecrmvwtabsdsl")
    public suspend fun agentPoolProfiles(argument: suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param values The agent pool properties.
     */
    @JvmName("fmhafuapjyrlukqd")
    public suspend fun agentPoolProfiles(vararg values: ManagedClusterAgentPoolProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param value The access profile for managed cluster API server.
     */
    @JvmName("kqgltnegthvhcyvx")
    public suspend fun apiServerAccessProfile(`value`: ManagedClusterAPIServerAccessProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiServerAccessProfile = mapped
    }

    /**
     * @param argument The access profile for managed cluster API server.
     */
    @JvmName("ciodaebemjwvtcii")
    public suspend fun apiServerAccessProfile(argument: suspend ManagedClusterAPIServerAccessProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAPIServerAccessProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apiServerAccessProfile = mapped
    }

    /**
     * @param value Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("kfuwpkxijhfgxync")
    public suspend fun autoScalerProfile(`value`: ManagedClusterPropertiesAutoScalerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalerProfile = mapped
    }

    /**
     * @param argument Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("wciqugndpjmuomwe")
    public suspend fun autoScalerProfile(argument: suspend ManagedClusterPropertiesAutoScalerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterPropertiesAutoScalerProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalerProfile = mapped
    }

    /**
     * @param value The auto upgrade configuration.
     */
    @JvmName("fsbdvndydtshwqkx")
    public suspend fun autoUpgradeProfile(`value`: ManagedClusterAutoUpgradeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeProfile = mapped
    }

    /**
     * @param argument The auto upgrade configuration.
     */
    @JvmName("vjmqkgqwvgsxekvr")
    public suspend fun autoUpgradeProfile(argument: suspend ManagedClusterAutoUpgradeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAutoUpgradeProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoUpgradeProfile = mapped
    }

    /**
     * @param value Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("miggjwqqbijntbuo")
    public suspend fun azureMonitorProfile(`value`: ManagedClusterAzureMonitorProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorProfile = mapped
    }

    /**
     * @param argument Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("cijlboudkpkumqwq")
    public suspend fun azureMonitorProfile(argument: suspend ManagedClusterAzureMonitorProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAzureMonitorProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorProfile = mapped
    }

    /**
     * @param value If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    @JvmName("cdjvghxkugmovoib")
    public suspend fun disableLocalAccounts(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAccounts = mapped
    }

    /**
     * @param value This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    @JvmName("kbuuqvbiixjbgplr")
    public suspend fun diskEncryptionSetID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetID = mapped
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("vpoqupvqqshetnjp")
    public suspend fun dnsPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsPrefix = mapped
    }

    /**
     * @param value (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     */
    @JvmName("evhcritawlipmfmc")
    public suspend fun enablePodSecurityPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePodSecurityPolicy = mapped
    }

    /**
     * @param value Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("aoefgddckemuwega")
    public suspend fun enableRBAC(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRBAC = mapped
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("uvggyeierqhmlgba")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the Virtual Machine.
     */
    @JvmName("kfmccqmatksiwioo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("wserervrqtjkbccn")
    public suspend fun fqdnSubdomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnSubdomain = mapped
    }

    /**
     * @param value Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("ujmpqaypwdmudbfl")
    public suspend fun httpProxyConfig(`value`: ManagedClusterHTTPProxyConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("thnvaafbexiyhjeu")
    public suspend fun httpProxyConfig(argument: suspend ManagedClusterHTTPProxyConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterHTTPProxyConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value The identity of the managed cluster, if configured.
     */
    @JvmName("dwnqubywbnpixnkd")
    public suspend fun identity(`value`: ManagedClusterIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the managed cluster, if configured.
     */
    @JvmName("gmmorkyaetlndxpw")
    public suspend fun identity(argument: suspend ManagedClusterIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Identities associated with the cluster.
     */
    @JvmName("vnpqrvuieivqmjvl")
    public suspend fun identityProfile(`value`: Map<String, UserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProfile = mapped
    }

    /**
     * @param argument Identities associated with the cluster.
     */
    @JvmName("ohfgxgnvksgsrutg")
    public suspend fun identityProfile(vararg argument: Pair<String, suspend UserAssignedIdentityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.identityProfile = mapped
    }

    /**
     * @param values Identities associated with the cluster.
     */
    @JvmName("edoedpashcbenwpf")
    public fun identityProfile(vararg values: Pair<String, UserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProfile = mapped
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    @JvmName("ilfruqblocsnnpry")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("kxrewvaqgfpxeiho")
    public suspend fun linuxProfile(`value`: ContainerServiceLinuxProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxProfile = mapped
    }

    /**
     * @param argument The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("gxudxtdkogpubjjp")
    public suspend fun linuxProfile(argument: suspend ContainerServiceLinuxProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceLinuxProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vxafiuhxsmymeqjc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network configuration profile.
     */
    @JvmName("dekcpenjasvxftfd")
    public suspend fun networkProfile(`value`: ContainerServiceNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The network configuration profile.
     */
    @JvmName("gvldgdlvqnhwhjxg")
    public suspend fun networkProfile(argument: suspend ContainerServiceNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The name of the resource group containing agent pool nodes.
     */
    @JvmName("rfjpopfbjjqjqvyy")
    public suspend fun nodeResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeResourceGroup = mapped
    }

    /**
     * @param value The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("lspjmilvxdcunaai")
    public suspend fun oidcIssuerProfile(`value`: ManagedClusterOIDCIssuerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcIssuerProfile = mapped
    }

    /**
     * @param argument The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("mhddfuifxlsssyjg")
    public suspend fun oidcIssuerProfile(argument: suspend ManagedClusterOIDCIssuerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterOIDCIssuerProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidcIssuerProfile = mapped
    }

    /**
     * @param value See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("giygatecewvdyuaw")
    public suspend fun podIdentityProfile(`value`: ManagedClusterPodIdentityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podIdentityProfile = mapped
    }

    /**
     * @param argument See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("nxloxsgwflibgqcf")
    public suspend fun podIdentityProfile(argument: suspend ManagedClusterPodIdentityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterPodIdentityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.podIdentityProfile = mapped
    }

    /**
     * @param value Private link resources associated with the cluster.
     */
    @JvmName("qepwmvehqfbnsotn")
    public suspend fun privateLinkResources(`value`: List<PrivateLinkResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("okwhaqppssrshxdn")
    public suspend fun privateLinkResources(argument: List<suspend PrivateLinkResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("jvgyhkniqstwavmt")
    public suspend fun privateLinkResources(vararg argument: suspend PrivateLinkResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("rbadhljtnptkrgvw")
    public suspend fun privateLinkResources(argument: suspend PrivateLinkResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivateLinkResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param values Private link resources associated with the cluster.
     */
    @JvmName("ltadtlqllhebdrrs")
    public suspend fun privateLinkResources(vararg values: PrivateLinkResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkResources = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("xlswlvbsipwslkmi")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("lxlfcsooyifrapxg")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("rcbqxgngbyvltbhq")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vmutfargvetbskhj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("aswgynxebeiuipyi")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Security profile for the managed cluster.
     */
    @JvmName("vitwijfjkvqyuviq")
    public suspend fun securityProfile(`value`: ManagedClusterSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Security profile for the managed cluster.
     */
    @JvmName("opikpfymqrrfbnbh")
    public suspend fun securityProfile(argument: suspend ManagedClusterSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("kygmvbsqaxeojkng")
    public suspend fun servicePrincipalProfile(`value`: ManagedClusterServicePrincipalProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param argument Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("xwyexfmljjtdsfda")
    public suspend fun servicePrincipalProfile(argument: suspend ManagedClusterServicePrincipalProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterServicePrincipalProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param value The managed cluster SKU.
     */
    @JvmName("eksoxnrpudxhbsoe")
    public suspend fun sku(`value`: ManagedClusterSKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The managed cluster SKU.
     */
    @JvmName("lowuilwanwqvwoup")
    public suspend fun sku(argument: suspend ManagedClusterSKUArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Storage profile for the managed cluster.
     */
    @JvmName("akxxmpobgwgxjlox")
    public suspend fun storageProfile(`value`: ManagedClusterStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage profile for the managed cluster.
     */
    @JvmName("jsmterfklktsualu")
    public suspend fun storageProfile(argument: suspend ManagedClusterStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("wdgivbmukewhompd")
    public suspend fun supportPlan(`value`: Either<String, KubernetesSupportPlan>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("ctmjiruidxwghrbn")
    public fun supportPlan(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KubernetesSupportPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("iudikcchdecruigv")
    public fun supportPlan(`value`: KubernetesSupportPlan) {
        val toBeMapped = Either.ofRight<String, KubernetesSupportPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("plyaxyarfargcydr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tpfcndhifffsngur")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("lxxjsrbelnhrdhiq")
    public suspend fun windowsProfile(`value`: ManagedClusterWindowsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsProfile = mapped
    }

    /**
     * @param argument The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("wcplnxlcocgdpbwf")
    public suspend fun windowsProfile(argument: suspend ManagedClusterWindowsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterWindowsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsProfile = mapped
    }

    /**
     * @param value Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("xddnlpechqpmtpnq")
    public suspend fun workloadAutoScalerProfile(`value`: ManagedClusterWorkloadAutoScalerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadAutoScalerProfile = mapped
    }

    /**
     * @param argument Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("ooxrkqyxxlkbkegu")
    public suspend fun workloadAutoScalerProfile(argument: suspend ManagedClusterWorkloadAutoScalerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterWorkloadAutoScalerProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workloadAutoScalerProfile = mapped
    }

    internal fun build(): ManagedClusterArgs = ManagedClusterArgs(
        aadProfile = aadProfile,
        addonProfiles = addonProfiles,
        agentPoolProfiles = agentPoolProfiles,
        apiServerAccessProfile = apiServerAccessProfile,
        autoScalerProfile = autoScalerProfile,
        autoUpgradeProfile = autoUpgradeProfile,
        azureMonitorProfile = azureMonitorProfile,
        disableLocalAccounts = disableLocalAccounts,
        diskEncryptionSetID = diskEncryptionSetID,
        dnsPrefix = dnsPrefix,
        enablePodSecurityPolicy = enablePodSecurityPolicy,
        enableRBAC = enableRBAC,
        extendedLocation = extendedLocation,
        fqdnSubdomain = fqdnSubdomain,
        httpProxyConfig = httpProxyConfig,
        identity = identity,
        identityProfile = identityProfile,
        kubernetesVersion = kubernetesVersion,
        linuxProfile = linuxProfile,
        location = location,
        networkProfile = networkProfile,
        nodeResourceGroup = nodeResourceGroup,
        oidcIssuerProfile = oidcIssuerProfile,
        podIdentityProfile = podIdentityProfile,
        privateLinkResources = privateLinkResources,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        securityProfile = securityProfile,
        servicePrincipalProfile = servicePrincipalProfile,
        sku = sku,
        storageProfile = storageProfile,
        supportPlan = supportPlan,
        tags = tags,
        windowsProfile = windowsProfile,
        workloadAutoScalerProfile = workloadAutoScalerProfile,
    )
}
