@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
 */
public enum class AgentPoolMode(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.AgentPoolMode,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.AgentPoolMode> {
    /**
     * System agent pools are primarily for hosting critical system pods such as CoreDNS and metrics-server. System agent pools osType must be Linux. System agent pools VM SKU must have at least 2vCPUs and 4GB of memory.
     */
    System(com.pulumi.azurenative.containerservice.enums.AgentPoolMode.System),

    /**
     * User agent pools are primarily for hosting your application pods.
     */
    User(com.pulumi.azurenative.containerservice.enums.AgentPoolMode.User),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.AgentPoolMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.AgentPoolMode): AgentPoolMode = AgentPoolMode.values().first { it.javaValue == javaType }
    }
}
