@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of Agent Pool.
 */
public enum class AgentPoolType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.AgentPoolType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.AgentPoolType> {
    /**
     * Create an Agent Pool backed by a Virtual Machine Scale Set.
     */
    VirtualMachineScaleSets(com.pulumi.azurenative.containerservice.enums.AgentPoolType.VirtualMachineScaleSets),

    /**
     * Use of this is strongly discouraged.
     */
    AvailabilitySet(com.pulumi.azurenative.containerservice.enums.AgentPoolType.AvailabilitySet),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.AgentPoolType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.AgentPoolType): AgentPoolType = AgentPoolType.values().first { it.javaValue == javaType }
    }
}
