@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tells whether the cluster is Running or Stopped
 */
public enum class Code(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.Code,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.Code> {
    /**
     * The cluster is running.
     */
    Running(com.pulumi.azurenative.containerservice.enums.Code.Running),

    /**
     * The cluster is stopped.
     */
    Stopped(com.pulumi.azurenative.containerservice.enums.Code.Stopped),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.Code = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.Code): Code =
            Code.values().first { it.javaValue == javaType }
    }
}
