@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The private link service connection status.
 */
public enum class ConnectionStatus(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ConnectionStatus> {
    Pending(com.pulumi.azurenative.containerservice.enums.ConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.containerservice.enums.ConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.containerservice.enums.ConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.containerservice.enums.ConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ConnectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ConnectionStatus): ConnectionStatus = ConnectionStatus.values().first { it.javaValue == javaType }
    }
}
