@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
 */
public enum class KubeletDiskType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.KubeletDiskType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.KubeletDiskType> {
    /**
     * Kubelet will use the OS disk for its data.
     */
    OS(com.pulumi.azurenative.containerservice.enums.KubeletDiskType.OS),

    /**
     * Kubelet will use the temporary disk for its data.
     */
    Temporary(com.pulumi.azurenative.containerservice.enums.KubeletDiskType.Temporary),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.KubeletDiskType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.KubeletDiskType): KubeletDiskType = KubeletDiskType.values().first { it.javaValue == javaType }
    }
}
