@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
 */
public enum class KubernetesSupportPlan(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan> {
    /**
     * Support for the version is the same as for the open source Kubernetes offering. Official Kubernetes open source community support versions for 1 year after release.
     */
    KubernetesOfficial(com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan.KubernetesOfficial),

    /**
     * Support for the version extended past the KubernetesOfficial support of 1 year. AKS continues to patch CVEs for another 1 year, for a total of 2 years of support.
     */
    AKSLongTermSupport(com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan.AKSLongTermSupport),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.KubernetesSupportPlan): KubernetesSupportPlan = KubernetesSupportPlan.values().first { it.javaValue == javaType }
    }
}
