@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
 */
public enum class LicenseType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.LicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.LicenseType> {
    /**
     * No additional licensing is applied.
     */
    None(com.pulumi.azurenative.containerservice.enums.LicenseType.None),

    /**
     * Enables Azure Hybrid User Benefits for Windows VMs.
     */
    Windows_Server(com.pulumi.azurenative.containerservice.enums.LicenseType.Windows_Server),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.LicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.LicenseType): LicenseType = LicenseType.values().first { it.javaValue == javaType }
    }
}
