@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
 */
public enum class LoadBalancerSku(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.LoadBalancerSku,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.LoadBalancerSku> {
    /**
     * Use a a standard Load Balancer. This is the recommended Load Balancer SKU. For more information about on working with the load balancer in the managed cluster, see the [standard Load Balancer](https://docs.microsoft.com/azure/aks/load-balancer-standard) article.
     */
    Standard(com.pulumi.azurenative.containerservice.enums.LoadBalancerSku.Standard),

    /**
     * Use a basic Load Balancer with limited functionality.
     */
    Basic(com.pulumi.azurenative.containerservice.enums.LoadBalancerSku.Basic),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.LoadBalancerSku = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.LoadBalancerSku): LoadBalancerSku = LoadBalancerSku.values().first { it.javaValue == javaType }
    }
}
