@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Network dataplane used in the Kubernetes cluster.
 */
public enum class NetworkDataplane(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.NetworkDataplane,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.NetworkDataplane> {
    /**
     * Use Azure network dataplane.
     */
    Azure(com.pulumi.azurenative.containerservice.enums.NetworkDataplane.Azure),

    /**
     * Use Cilium network dataplane. See [Azure CNI Powered by Cilium](https://learn.microsoft.com/azure/aks/azure-cni-powered-by-cilium) for more information.
     */
    Cilium(com.pulumi.azurenative.containerservice.enums.NetworkDataplane.Cilium),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.NetworkDataplane = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.NetworkDataplane): NetworkDataplane = NetworkDataplane.values().first { it.javaValue == javaType }
    }
}
