@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This cannot be specified if networkPlugin is anything other than 'azure'.
 */
public enum class NetworkMode(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.NetworkMode,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.NetworkMode> {
    /**
     * No bridge is created. Intra-VM Pod to Pod communication is through IP routes created by Azure CNI. See [Transparent Mode](https://docs.microsoft.com/azure/aks/faq#transparent-mode) for more information.
     */
    Transparent(com.pulumi.azurenative.containerservice.enums.NetworkMode.Transparent),

    /**
     * This is no longer supported
     */
    Bridge(com.pulumi.azurenative.containerservice.enums.NetworkMode.Bridge),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.NetworkMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.NetworkMode): NetworkMode = NetworkMode.values().first { it.javaValue == javaType }
    }
}
