@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The mode the network plugin should use.
 */
public enum class NetworkPluginMode(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.NetworkPluginMode,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.NetworkPluginMode> {
    /**
     * Used with networkPlugin=azure, pods are given IPs from the PodCIDR address space but use Azure Routing Domains rather than Kubenet's method of route tables. For more information visit https://aka.ms/aks/azure-cni-overlay.
     */
    Overlay(com.pulumi.azurenative.containerservice.enums.NetworkPluginMode.Overlay),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.NetworkPluginMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.NetworkPluginMode): NetworkPluginMode = NetworkPluginMode.values().first { it.javaValue == javaType }
    }
}
