@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
 */
public enum class OSDiskType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.OSDiskType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.OSDiskType> {
    /**
     * Azure replicates the operating system disk for a virtual machine to Azure storage to avoid data loss should the VM need to be relocated to another host. Since containers aren't designed to have local state persisted, this behavior offers limited value while providing some drawbacks, including slower node provisioning and higher read/write latency.
     */
    Managed(com.pulumi.azurenative.containerservice.enums.OSDiskType.Managed),

    /**
     * Ephemeral OS disks are stored only on the host machine, just like a temporary disk. This provides lower read/write latency, along with faster node scaling and cluster upgrades.
     */
    Ephemeral(com.pulumi.azurenative.containerservice.enums.OSDiskType.Ephemeral),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.OSDiskType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.OSDiskType): OSDiskType = OSDiskType.values().first { it.javaValue == javaType }
    }
}
