@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * operator represents a key's relationship to a set of values. Valid operators are In and NotIn
 */
public enum class Operator(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.Operator,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.Operator> {
    /**
     * The value of the key should be in the given list.
     */
    In(com.pulumi.azurenative.containerservice.enums.Operator.In),

    /**
     * The value of the key should not be in the given list.
     */
    NotIn(com.pulumi.azurenative.containerservice.enums.Operator.NotIn),

    /**
     * The value of the key should exist.
     */
    Exists(com.pulumi.azurenative.containerservice.enums.Operator.Exists),

    /**
     * The value of the key should not exist.
     */
    DoesNotExist(com.pulumi.azurenative.containerservice.enums.Operator.DoesNotExist),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.Operator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.Operator): Operator = Operator.values().first { it.javaValue == javaType }
    }
}
