@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ResourceIdentityType> {
    /**
     * Use an implicitly created system assigned managed identity to manage cluster resources. Master components in the control plane such as kube-controller-manager will use the system assigned managed identity to manipulate Azure resources.
     */
    SystemAssigned(com.pulumi.azurenative.containerservice.enums.ResourceIdentityType.SystemAssigned),

    /**
     * Use a user-specified identity to manage cluster resources. Master components in the control plane such as kube-controller-manager will use the specified user assigned managed identity to manipulate Azure resources.
     */
    UserAssigned(com.pulumi.azurenative.containerservice.enums.ResourceIdentityType.UserAssigned),

    /**
     * Do not use a managed identity for the Managed Cluster, service principal will be used instead.
     */
    None(com.pulumi.azurenative.containerservice.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
