@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
 */
public enum class ScaleDownMode(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ScaleDownMode,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ScaleDownMode> {
    /**
     * Create new instances during scale up and remove instances during scale down.
     */
    Delete(com.pulumi.azurenative.containerservice.enums.ScaleDownMode.Delete),

    /**
     * Attempt to start deallocated instances (if they exist) during scale up and deallocate instances during scale down.
     */
    Deallocate(com.pulumi.azurenative.containerservice.enums.ScaleDownMode.Deallocate),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ScaleDownMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ScaleDownMode): ScaleDownMode = ScaleDownMode.values().first { it.javaValue == javaType }
    }
}
