@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of a snapshot. The default is NodePool.
 */
public enum class SnapshotType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.SnapshotType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.SnapshotType> {
    /**
     * The snapshot is a snapshot of a node pool.
     */
    NodePool(com.pulumi.azurenative.containerservice.enums.SnapshotType.NodePool),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.SnapshotType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.SnapshotType): SnapshotType = SnapshotType.values().first { it.javaValue == javaType }
    }
}
