@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
 */
public enum class UpgradeChannel(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.UpgradeChannel,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.UpgradeChannel> {
    /**
     * Automatically upgrade the cluster to the latest supported patch release on the latest supported minor version. In cases where the cluster is at a version of Kubernetes that is at an N-2 minor version where N is the latest supported minor version, the cluster first upgrades to the latest supported patch version on N-1 minor version. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster first is upgraded to 1.18.6, then is upgraded to 1.19.1.
     */
    Rapid(com.pulumi.azurenative.containerservice.enums.UpgradeChannel.Rapid),

    /**
     * Automatically upgrade the cluster to the latest supported patch release on minor version N-1, where N is the latest supported minor version. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded to 1.18.6.
     */
    Stable(com.pulumi.azurenative.containerservice.enums.UpgradeChannel.Stable),

    /**
     * Automatically upgrade the cluster to the latest supported patch version when it becomes available while keeping the minor version the same. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded to 1.17.9.
     */
    Patch(com.pulumi.azurenative.containerservice.enums.UpgradeChannel.Patch),

    /**
     * Automatically upgrade the node image to the latest version available. Microsoft provides patches and new images for image nodes frequently (usually weekly), but your running nodes won't get the new images unless you do a node image upgrade. Turning on the node-image channel will automatically update your node images whenever a new version is available.
     */
    Nodeimage(com.pulumi.azurenative.containerservice.enums.UpgradeChannel.Nodeimage),

    /**
     * Disables auto-upgrades and keeps the cluster at its current version of Kubernetes.
     */
    None(com.pulumi.azurenative.containerservice.enums.UpgradeChannel.None),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.UpgradeChannel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.UpgradeChannel): UpgradeChannel = UpgradeChannel.values().first { it.javaValue == javaType }
    }
}
