@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the type of workload a node can run.
 */
public enum class WorkloadRuntime(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.WorkloadRuntime,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.WorkloadRuntime> {
    /**
     * Nodes will use Kubelet to run standard OCI container workloads.
     */
    OCIContainer(com.pulumi.azurenative.containerservice.enums.WorkloadRuntime.OCIContainer),

    /**
     * Nodes will use Krustlet to run WASM workloads using the WASI provider (Preview).
     */
    WasmWasi(com.pulumi.azurenative.containerservice.enums.WorkloadRuntime.WasmWasi),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.WorkloadRuntime = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.WorkloadRuntime): WorkloadRuntime = WorkloadRuntime.values().first { it.javaValue == javaType }
    }
}
