@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Profile for Linux VMs in the container service cluster.
 * @property adminUsername The administrator username to use for Linux VMs.
 * @property ssh The SSH configuration for Linux-based VMs running on Azure.
 */
public data class ContainerServiceLinuxProfileArgs(
    public val adminUsername: Output<String>,
    public val ssh: Output<ContainerServiceSshConfigurationArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceLinuxProfileArgs.builder()
            .adminUsername(adminUsername.applyValue({ args0 -> args0 }))
            .ssh(ssh.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerServiceLinuxProfileArgs].
 */
@PulumiTagMarker
public class ContainerServiceLinuxProfileArgsBuilder internal constructor() {
    private var adminUsername: Output<String>? = null

    private var ssh: Output<ContainerServiceSshConfigurationArgs>? = null

    /**
     * @param value The administrator username to use for Linux VMs.
     */
    @JvmName("avqclcdujchkbtmv")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value The SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("kwfinpvltabojbmg")
    public suspend fun ssh(`value`: Output<ContainerServiceSshConfigurationArgs>) {
        this.ssh = value
    }

    /**
     * @param value The administrator username to use for Linux VMs.
     */
    @JvmName("ogphjpknfoodwotc")
    public suspend fun adminUsername(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value The SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("huetarrhkantsdpn")
    public suspend fun ssh(`value`: ContainerServiceSshConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument The SSH configuration for Linux-based VMs running on Azure.
     */
    @JvmName("xyghevsovjnsweeo")
    public suspend fun ssh(argument: suspend ContainerServiceSshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceSshConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    internal fun build(): ContainerServiceLinuxProfileArgs = ContainerServiceLinuxProfileArgs(
        adminUsername = adminUsername ?: throw PulumiNullFieldException("adminUsername"),
        ssh = ssh ?: throw PulumiNullFieldException("ssh"),
    )
}
