@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetFleetUpdateStrategyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetName The name of the Fleet resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updateStrategyName The name of the UpdateStrategy resource.
 */
public data class GetFleetUpdateStrategyPlainArgs(
    public val fleetName: String,
    public val resourceGroupName: String,
    public val updateStrategyName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetFleetUpdateStrategyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.GetFleetUpdateStrategyPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetFleetUpdateStrategyPlainArgs.builder()
            .fleetName(fleetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .updateStrategyName(updateStrategyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFleetUpdateStrategyPlainArgs].
 */
@PulumiTagMarker
public class GetFleetUpdateStrategyPlainArgsBuilder internal constructor() {
    private var fleetName: String? = null

    private var resourceGroupName: String? = null

    private var updateStrategyName: String? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("rcshlihyrdgjjtmf")
    public suspend fun fleetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ibvajhbgxvvyalqe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the UpdateStrategy resource.
     */
    @JvmName("mqhaxkjvpniabfid")
    public suspend fun updateStrategyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.updateStrategyName = mapped
    }

    internal fun build(): GetFleetUpdateStrategyPlainArgs = GetFleetUpdateStrategyPlainArgs(
        fleetName = fleetName ?: throw PulumiNullFieldException("fleetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        updateStrategyName = updateStrategyName ?: throw PulumiNullFieldException("updateStrategyName"),
    )
}
