@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetLoadBalancerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property loadBalancerName The name of the load balancer.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 */
public data class GetLoadBalancerPlainArgs(
    public val loadBalancerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetLoadBalancerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.GetLoadBalancerPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetLoadBalancerPlainArgs.builder()
            .loadBalancerName(loadBalancerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancerPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerPlainArgsBuilder internal constructor() {
    private var loadBalancerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("pjlbwftqebtudjiw")
    public suspend fun loadBalancerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mqmbeyqqmwpkbpff")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("diswtcethnaixada")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetLoadBalancerPlainArgs = GetLoadBalancerPlainArgs(
        loadBalancerName = loadBalancerName ?: throw PulumiNullFieldException("loadBalancerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
