@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.LabelSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
 * @property matchExpressions matchExpressions is a list of label selector requirements. The requirements are ANDed.
 * @property matchLabels matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
 */
public data class LabelSelectorArgs(
    public val matchExpressions: Output<List<LabelSelectorRequirementArgs>>? = null,
    public val matchLabels: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.LabelSelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.LabelSelectorArgs =
        com.pulumi.azurenative.containerservice.inputs.LabelSelectorArgs.builder()
            .matchExpressions(
                matchExpressions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchLabels(matchLabels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LabelSelectorArgs].
 */
@PulumiTagMarker
public class LabelSelectorArgsBuilder internal constructor() {
    private var matchExpressions: Output<List<LabelSelectorRequirementArgs>>? = null

    private var matchLabels: Output<List<String>>? = null

    /**
     * @param value matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("vhsqvhupojbyjlmw")
    public suspend fun matchExpressions(`value`: Output<List<LabelSelectorRequirementArgs>>) {
        this.matchExpressions = value
    }

    @JvmName("lmpovycjgrshcryr")
    public suspend fun matchExpressions(vararg values: Output<LabelSelectorRequirementArgs>) {
        this.matchExpressions = Output.all(values.asList())
    }

    /**
     * @param values matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("dniacdsqywtoyuuq")
    public suspend fun matchExpressions(values: List<Output<LabelSelectorRequirementArgs>>) {
        this.matchExpressions = Output.all(values)
    }

    /**
     * @param value matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
     */
    @JvmName("scjtvekvpsvwdsdj")
    public suspend fun matchLabels(`value`: Output<List<String>>) {
        this.matchLabels = value
    }

    @JvmName("slmrrhggqnrcolma")
    public suspend fun matchLabels(vararg values: Output<String>) {
        this.matchLabels = Output.all(values.asList())
    }

    /**
     * @param values matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
     */
    @JvmName("cavamqhqvkvcrgcc")
    public suspend fun matchLabels(values: List<Output<String>>) {
        this.matchLabels = Output.all(values)
    }

    /**
     * @param value matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("ulerxbghwaesrnvr")
    public suspend fun matchExpressions(`value`: List<LabelSelectorRequirementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpressions = mapped
    }

    /**
     * @param argument matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("eyktiexgrmkievxk")
    public suspend fun matchExpressions(argument: List<suspend LabelSelectorRequirementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LabelSelectorRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param argument matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("dyowmhwckoejqtdb")
    public suspend fun matchExpressions(vararg argument: suspend LabelSelectorRequirementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LabelSelectorRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param argument matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("jdechrdgpnutylmy")
    public suspend fun matchExpressions(argument: suspend LabelSelectorRequirementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LabelSelectorRequirementArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param values matchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("jabiykcnfejrjonp")
    public suspend fun matchExpressions(vararg values: LabelSelectorRequirementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchExpressions = mapped
    }

    /**
     * @param value matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
     */
    @JvmName("mdjaoimpphlmaugg")
    public suspend fun matchLabels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    /**
     * @param values matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
     */
    @JvmName("wsowporgmhraepha")
    public suspend fun matchLabels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    internal fun build(): LabelSelectorArgs = LabelSelectorArgs(
        matchExpressions = matchExpressions,
        matchLabels = matchLabels,
    )
}
