@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.LabelSelectorRequirementArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.Operator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
 * @property key key is the label key that the selector applies to.
 * @property operator operator represents a key's relationship to a set of values. Valid operators are In and NotIn
 * @property values values is an array of string values, the values array must be non-empty.
 */
public data class LabelSelectorRequirementArgs(
    public val key: Output<String>? = null,
    public val `operator`: Output<Either<String, Operator>>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.LabelSelectorRequirementArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.LabelSelectorRequirementArgs = com.pulumi.azurenative.containerservice.inputs.LabelSelectorRequirementArgs.builder()
        .key(key?.applyValue({ args0 -> args0 }))
        .`operator`(
            `operator`?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LabelSelectorRequirementArgs].
 */
@PulumiTagMarker
public class LabelSelectorRequirementArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value key is the label key that the selector applies to.
     */
    @JvmName("maynlqrwrjcfxirf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In and NotIn
     */
    @JvmName("jbcgxoelwtvhyxby")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value values is an array of string values, the values array must be non-empty.
     */
    @JvmName("yrviyhmymqdfgwag")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("iobrairtpfxokvyr")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values values is an array of string values, the values array must be non-empty.
     */
    @JvmName("ntbdwlqvlklulpnq")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value key is the label key that the selector applies to.
     */
    @JvmName("gdllbevousakkoac")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In and NotIn
     */
    @JvmName("kvkutchpjvuatmrv")
    public suspend fun `operator`(`value`: Either<String, Operator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In and NotIn
     */
    @JvmName("kepcvsvkvjefsdem")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value operator represents a key's relationship to a set of values. Valid operators are In and NotIn
     */
    @JvmName("yyfbpwnkgxhewfhd")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value values is an array of string values, the values array must be non-empty.
     */
    @JvmName("jiqystrwcfxnnusa")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values values is an array of string values, the values array must be non-empty.
     */
    @JvmName("xsbactpqbguqstci")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): LabelSelectorRequirementArgs = LabelSelectorRequirementArgs(
        key = key,
        `operator` = `operator`,
        values = values,
    )
}
