@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAdminCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property serverFqdn server fqdn type for credentials to be returned
 */
public data class ListManagedClusterAdminCredentialsPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val serverFqdn: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAdminCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAdminCredentialsPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.ListManagedClusterAdminCredentialsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .serverFqdn(serverFqdn?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListManagedClusterAdminCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListManagedClusterAdminCredentialsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var serverFqdn: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oiorqtxgdwngvkbg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("wqmvrjkfhqofahqc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value server fqdn type for credentials to be returned
     */
    @JvmName("aowqnixmawcbmsul")
    public suspend fun serverFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverFqdn = mapped
    }

    internal fun build(): ListManagedClusterAdminCredentialsPlainArgs =
        ListManagedClusterAdminCredentialsPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            serverFqdn = serverFqdn,
        )
}
