@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Desired managed outbound IPs for the cluster load balancer.
 * @property count The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
 * @property countIPv6 The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
 */
public data class ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs(
    public val count: Output<Int>? = null,
    public val countIPv6: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .countIPv6(countIPv6?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs].
 */
@PulumiTagMarker
public class ManagedClusterLoadBalancerProfileManagedOutboundIPsArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var countIPv6: Output<Int>? = null

    /**
     * @param value The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("vqnqesdmpvkdqsdf")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
     */
    @JvmName("fnyxbghhsapebpmu")
    public suspend fun countIPv6(`value`: Output<Int>) {
        this.countIPv6 = value
    }

    /**
     * @param value The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JvmName("qymmcrgokqvnfwjn")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
     */
    @JvmName("yeljcamdwkchdoem")
    public suspend fun countIPv6(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countIPv6 = mapped
    }

    internal fun build(): ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs =
        ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs(
            count = count,
            countIPv6 = countIPv6,
        )
}
