@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on pod identity integration.
 * @property allowNetworkPluginKubenet Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
 * @property enabled Whether the pod identity addon is enabled.
 * @property userAssignedIdentities The pod identities to use in the cluster.
 * @property userAssignedIdentityExceptions The pod identity exceptions to allow.
 */
public data class ManagedClusterPodIdentityProfileArgs(
    public val allowNetworkPluginKubenet: Output<Boolean>? = null,
    public val enabled: Output<Boolean>? = null,
    public val userAssignedIdentities: Output<List<ManagedClusterPodIdentityArgs>>? = null,
    public val userAssignedIdentityExceptions: Output<List<ManagedClusterPodIdentityExceptionArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityProfileArgs.builder()
            .allowNetworkPluginKubenet(allowNetworkPluginKubenet?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userAssignedIdentityExceptions(
                userAssignedIdentityExceptions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterPodIdentityProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterPodIdentityProfileArgsBuilder internal constructor() {
    private var allowNetworkPluginKubenet: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var userAssignedIdentities: Output<List<ManagedClusterPodIdentityArgs>>? = null

    private var userAssignedIdentityExceptions: Output<List<ManagedClusterPodIdentityExceptionArgs>>? =
        null

    /**
     * @param value Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
     */
    @JvmName("hsjawycpysqqbhsh")
    public suspend fun allowNetworkPluginKubenet(`value`: Output<Boolean>) {
        this.allowNetworkPluginKubenet = value
    }

    /**
     * @param value Whether the pod identity addon is enabled.
     */
    @JvmName("wixgmrrmootrpygp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The pod identities to use in the cluster.
     */
    @JvmName("dldbtguilkhrppls")
    public suspend fun userAssignedIdentities(`value`: Output<List<ManagedClusterPodIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("udalerjtqjnccbly")
    public suspend fun userAssignedIdentities(vararg values: Output<ManagedClusterPodIdentityArgs>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The pod identities to use in the cluster.
     */
    @JvmName("fjkcbgyubesxjsxa")
    public suspend fun userAssignedIdentities(values: List<Output<ManagedClusterPodIdentityArgs>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The pod identity exceptions to allow.
     */
    @JvmName("cqehwojymddtqtwc")
    public suspend fun userAssignedIdentityExceptions(`value`: Output<List<ManagedClusterPodIdentityExceptionArgs>>) {
        this.userAssignedIdentityExceptions = value
    }

    @JvmName("bftaptmaglmbyjmd")
    public suspend fun userAssignedIdentityExceptions(vararg values: Output<ManagedClusterPodIdentityExceptionArgs>) {
        this.userAssignedIdentityExceptions = Output.all(values.asList())
    }

    /**
     * @param values The pod identity exceptions to allow.
     */
    @JvmName("wehwloqtpsfieolw")
    public suspend fun userAssignedIdentityExceptions(values: List<Output<ManagedClusterPodIdentityExceptionArgs>>) {
        this.userAssignedIdentityExceptions = Output.all(values)
    }

    /**
     * @param value Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
     */
    @JvmName("rtrenpxjqtjbinmw")
    public suspend fun allowNetworkPluginKubenet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowNetworkPluginKubenet = mapped
    }

    /**
     * @param value Whether the pod identity addon is enabled.
     */
    @JvmName("ujtemxbgwwjfdyub")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The pod identities to use in the cluster.
     */
    @JvmName("scdmxrhblwfeaixo")
    public suspend fun userAssignedIdentities(`value`: List<ManagedClusterPodIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The pod identities to use in the cluster.
     */
    @JvmName("maqrkyrhjibxhjth")
    public suspend fun userAssignedIdentities(argument: List<suspend ManagedClusterPodIdentityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedClusterPodIdentityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The pod identities to use in the cluster.
     */
    @JvmName("faxiljpxrlfybeng")
    public suspend fun userAssignedIdentities(vararg argument: suspend ManagedClusterPodIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedClusterPodIdentityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The pod identities to use in the cluster.
     */
    @JvmName("nyinbowvrvvawpfh")
    public suspend fun userAssignedIdentities(argument: suspend ManagedClusterPodIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedClusterPodIdentityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The pod identities to use in the cluster.
     */
    @JvmName("ulbnfxxuetmurqwp")
    public suspend fun userAssignedIdentities(vararg values: ManagedClusterPodIdentityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param value The pod identity exceptions to allow.
     */
    @JvmName("kjsoflvunmfawugs")
    public suspend fun userAssignedIdentityExceptions(`value`: List<ManagedClusterPodIdentityExceptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityExceptions = mapped
    }

    /**
     * @param argument The pod identity exceptions to allow.
     */
    @JvmName("tstcxocbbwerblau")
    public suspend fun userAssignedIdentityExceptions(argument: List<suspend ManagedClusterPodIdentityExceptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedClusterPodIdentityExceptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userAssignedIdentityExceptions = mapped
    }

    /**
     * @param argument The pod identity exceptions to allow.
     */
    @JvmName("lnfhxryxjqowsuyi")
    public suspend fun userAssignedIdentityExceptions(vararg argument: suspend ManagedClusterPodIdentityExceptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedClusterPodIdentityExceptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userAssignedIdentityExceptions = mapped
    }

    /**
     * @param argument The pod identity exceptions to allow.
     */
    @JvmName("sgcocppgbfgmjmkh")
    public suspend fun userAssignedIdentityExceptions(argument: suspend ManagedClusterPodIdentityExceptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedClusterPodIdentityExceptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userAssignedIdentityExceptions = mapped
    }

    /**
     * @param values The pod identity exceptions to allow.
     */
    @JvmName("affcirkrkfqtbpik")
    public suspend fun userAssignedIdentityExceptions(vararg values: ManagedClusterPodIdentityExceptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentityExceptions = mapped
    }

    internal fun build(): ManagedClusterPodIdentityProfileArgs = ManagedClusterPodIdentityProfileArgs(
        allowNetworkPluginKubenet = allowNetworkPluginKubenet,
        enabled = enabled,
        userAssignedIdentities = userAssignedIdentities,
        userAssignedIdentityExceptions = userAssignedIdentityExceptions,
    )
}
