@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Microsoft Defender settings for the security profile.
 * @property logAnalyticsWorkspaceResourceId Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
 * @property securityMonitoring Microsoft Defender threat detection for Cloud settings for the security profile.
 */
public data class ManagedClusterSecurityProfileDefenderArgs(
    public val logAnalyticsWorkspaceResourceId: Output<String>? = null,
    public val securityMonitoring: Output<ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderArgs.builder()
            .logAnalyticsWorkspaceResourceId(logAnalyticsWorkspaceResourceId?.applyValue({ args0 -> args0 }))
            .securityMonitoring(
                securityMonitoring?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterSecurityProfileDefenderArgs].
 */
@PulumiTagMarker
public class ManagedClusterSecurityProfileDefenderArgsBuilder internal constructor() {
    private var logAnalyticsWorkspaceResourceId: Output<String>? = null

    private var securityMonitoring:
        Output<ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs>? = null

    /**
     * @param value Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
     */
    @JvmName("quatrutibwiukwmd")
    public suspend fun logAnalyticsWorkspaceResourceId(`value`: Output<String>) {
        this.logAnalyticsWorkspaceResourceId = value
    }

    /**
     * @param value Microsoft Defender threat detection for Cloud settings for the security profile.
     */
    @JvmName("qofrcljapspclxyg")
    public suspend fun securityMonitoring(`value`: Output<ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs>) {
        this.securityMonitoring = value
    }

    /**
     * @param value Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
     */
    @JvmName("uiurudbonpxaktda")
    public suspend fun logAnalyticsWorkspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsWorkspaceResourceId = mapped
    }

    /**
     * @param value Microsoft Defender threat detection for Cloud settings for the security profile.
     */
    @JvmName("ocdpchjmuptkcyji")
    public suspend fun securityMonitoring(`value`: ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityMonitoring = mapped
    }

    /**
     * @param argument Microsoft Defender threat detection for Cloud settings for the security profile.
     */
    @JvmName("ysngfuwohobawvno")
    public suspend fun securityMonitoring(argument: suspend ManagedClusterSecurityProfileDefenderSecurityMonitoringArgsBuilder.() -> Unit) {
        val toBeMapped =
            ManagedClusterSecurityProfileDefenderSecurityMonitoringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.securityMonitoring = mapped
    }

    internal fun build(): ManagedClusterSecurityProfileDefenderArgs =
        ManagedClusterSecurityProfileDefenderArgs(
            logAnalyticsWorkspaceResourceId = logAnalyticsWorkspaceResourceId,
            securityMonitoring = securityMonitoring,
        )
}
