@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileImageCleanerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image Cleaner removes unused images from nodes, freeing up disk space and helping to reduce attack surface area. Here are settings for the security profile.
 * @property enabled Whether to enable Image Cleaner on AKS cluster.
 * @property intervalHours Image Cleaner scanning interval in hours.
 */
public data class ManagedClusterSecurityProfileImageCleanerArgs(
    public val enabled: Output<Boolean>? = null,
    public val intervalHours: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileImageCleanerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileImageCleanerArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileImageCleanerArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .intervalHours(intervalHours?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterSecurityProfileImageCleanerArgs].
 */
@PulumiTagMarker
public class ManagedClusterSecurityProfileImageCleanerArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var intervalHours: Output<Int>? = null

    /**
     * @param value Whether to enable Image Cleaner on AKS cluster.
     */
    @JvmName("covuyuggosoleyqg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Image Cleaner scanning interval in hours.
     */
    @JvmName("vflykrfkocsdaoks")
    public suspend fun intervalHours(`value`: Output<Int>) {
        this.intervalHours = value
    }

    /**
     * @param value Whether to enable Image Cleaner on AKS cluster.
     */
    @JvmName("inikdxntqeiqutti")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Image Cleaner scanning interval in hours.
     */
    @JvmName("iihcnkxheqdrbniu")
    public suspend fun intervalHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalHours = mapped
    }

    internal fun build(): ManagedClusterSecurityProfileImageCleanerArgs =
        ManagedClusterSecurityProfileImageCleanerArgs(
            enabled = enabled,
            intervalHours = intervalHours,
        )
}
