@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload identity settings for the security profile.
 * @property enabled Whether to enable workload identity.
 */
public data class ManagedClusterSecurityProfileWorkloadIdentityArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterSecurityProfileWorkloadIdentityArgs].
 */
@PulumiTagMarker
public class ManagedClusterSecurityProfileWorkloadIdentityArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable workload identity.
     */
    @JvmName("egdtkugnqjfpqori")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable workload identity.
     */
    @JvmName("pekuxwxguyybtuxo")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterSecurityProfileWorkloadIdentityArgs =
        ManagedClusterSecurityProfileWorkloadIdentityArgs(
            enabled = enabled,
        )
}
