@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpgradeSpecArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.ManagedClusterUpgradeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The upgrade to apply to a ManagedCluster.
 * @property kubernetesVersion The Kubernetes version to upgrade the member clusters to.
 * @property type ManagedClusterUpgradeType is the type of upgrade to be applied.
 */
public data class ManagedClusterUpgradeSpecArgs(
    public val kubernetesVersion: Output<String>? = null,
    public val type: Output<Either<String, ManagedClusterUpgradeType>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpgradeSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpgradeSpecArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpgradeSpecArgs.builder()
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterUpgradeSpecArgs].
 */
@PulumiTagMarker
public class ManagedClusterUpgradeSpecArgsBuilder internal constructor() {
    private var kubernetesVersion: Output<String>? = null

    private var type: Output<Either<String, ManagedClusterUpgradeType>>? = null

    /**
     * @param value The Kubernetes version to upgrade the member clusters to.
     */
    @JvmName("oitkbelannlcbcap")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value ManagedClusterUpgradeType is the type of upgrade to be applied.
     */
    @JvmName("yymvudycfjnpckaf")
    public suspend fun type(`value`: Output<Either<String, ManagedClusterUpgradeType>>) {
        this.type = value
    }

    /**
     * @param value The Kubernetes version to upgrade the member clusters to.
     */
    @JvmName("gjhuhoaiwovhmdyi")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value ManagedClusterUpgradeType is the type of upgrade to be applied.
     */
    @JvmName("bogvirvgkiqhrhly")
    public suspend fun type(`value`: Either<String, ManagedClusterUpgradeType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value ManagedClusterUpgradeType is the type of upgrade to be applied.
     */
    @JvmName("xladceikakevlguj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedClusterUpgradeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value ManagedClusterUpgradeType is the type of upgrade to be applied.
     */
    @JvmName("foabllerpityctxp")
    public fun type(`value`: ManagedClusterUpgradeType) {
        val toBeMapped = Either.ofRight<String, ManagedClusterUpgradeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedClusterUpgradeSpecArgs = ManagedClusterUpgradeSpecArgs(
        kubernetesVersion = kubernetesVersion,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
