@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileKedaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
 * @property enabled Whether to enable KEDA.
 */
public data class ManagedClusterWorkloadAutoScalerProfileKedaArgs(
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileKedaArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileKedaArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileKedaArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterWorkloadAutoScalerProfileKedaArgs].
 */
@PulumiTagMarker
public class ManagedClusterWorkloadAutoScalerProfileKedaArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable KEDA.
     */
    @JvmName("tconsvabosorblcn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable KEDA.
     */
    @JvmName("gmgtqqyqdqkvppef")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterWorkloadAutoScalerProfileKedaArgs =
        ManagedClusterWorkloadAutoScalerProfileKedaArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
