@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the OpenShift networking configuration
 * @property managementSubnetCidr CIDR of subnet used to create PLS needed for management of the cluster
 * @property vnetCidr CIDR for the OpenShift Vnet.
 * @property vnetId ID of the Vnet created for OSA cluster.
 */
public data class NetworkProfileArgs(
    public val managementSubnetCidr: Output<String>? = null,
    public val vnetCidr: Output<String>? = null,
    public val vnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.NetworkProfileArgs.builder()
            .managementSubnetCidr(managementSubnetCidr?.applyValue({ args0 -> args0 }))
            .vnetCidr(vnetCidr?.applyValue({ args0 -> args0 }))
            .vnetId(vnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var managementSubnetCidr: Output<String>? = null

    private var vnetCidr: Output<String>? = null

    private var vnetId: Output<String>? = null

    /**
     * @param value CIDR of subnet used to create PLS needed for management of the cluster
     */
    @JvmName("wyhnhcjdhdqmjtks")
    public suspend fun managementSubnetCidr(`value`: Output<String>) {
        this.managementSubnetCidr = value
    }

    /**
     * @param value CIDR for the OpenShift Vnet.
     */
    @JvmName("vulctodefprmqjdy")
    public suspend fun vnetCidr(`value`: Output<String>) {
        this.vnetCidr = value
    }

    /**
     * @param value ID of the Vnet created for OSA cluster.
     */
    @JvmName("kpmghvuoaooxlded")
    public suspend fun vnetId(`value`: Output<String>) {
        this.vnetId = value
    }

    /**
     * @param value CIDR of subnet used to create PLS needed for management of the cluster
     */
    @JvmName("jyeyekiyrwdysnpo")
    public suspend fun managementSubnetCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementSubnetCidr = mapped
    }

    /**
     * @param value CIDR for the OpenShift Vnet.
     */
    @JvmName("lwyevffxmmxvtpwl")
    public suspend fun vnetCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetCidr = mapped
    }

    /**
     * @param value ID of the Vnet created for OSA cluster.
     */
    @JvmName("imwbvjqwtkxiwnvi")
    public suspend fun vnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetId = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        managementSubnetCidr = managementSubnetCidr,
        vnetCidr = vnetCidr,
        vnetId = vnetId,
    )
}
