@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAgentPoolProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.OSType
import com.pulumi.azurenative.containerservice.kotlin.enums.OpenShiftAgentPoolProfileRole
import com.pulumi.azurenative.containerservice.kotlin.enums.OpenShiftContainerServiceVMSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the configuration of the OpenShift cluster VMs.
 * @property count Number of agents (VMs) to host docker containers.
 * @property name Unique name of the pool profile in the context of the subscription and resource group.
 * @property osType OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
 * @property role Define the role of the AgentPoolProfile.
 * @property subnetCidr Subnet CIDR for the peering.
 * @property vmSize Size of agent VMs.
 */
public data class OpenShiftManagedClusterAgentPoolProfileArgs(
    public val count: Output<Int>,
    public val name: Output<String>,
    public val osType: Output<Either<String, OSType>>? = null,
    public val role: Output<Either<String, OpenShiftAgentPoolProfileRole>>? = null,
    public val subnetCidr: Output<String>? = null,
    public val vmSize: Output<Either<String, OpenShiftContainerServiceVMSize>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAgentPoolProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAgentPoolProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAgentPoolProfileArgs.builder()
            .count(count.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetCidr(subnetCidr?.applyValue({ args0 -> args0 }))
            .vmSize(
                vmSize.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenShiftManagedClusterAgentPoolProfileArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterAgentPoolProfileArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var name: Output<String>? = null

    private var osType: Output<Either<String, OSType>>? = null

    private var role: Output<Either<String, OpenShiftAgentPoolProfileRole>>? = null

    private var subnetCidr: Output<String>? = null

    private var vmSize: Output<Either<String, OpenShiftContainerServiceVMSize>>? = null

    /**
     * @param value Number of agents (VMs) to host docker containers.
     */
    @JvmName("iudsmvctvphiwhqg")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Unique name of the pool profile in the context of the subscription and resource group.
     */
    @JvmName("jgwfhmukiatwwvhb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JvmName("bgphccispqqrcqsq")
    public suspend fun osType(`value`: Output<Either<String, OSType>>) {
        this.osType = value
    }

    /**
     * @param value Define the role of the AgentPoolProfile.
     */
    @JvmName("pxhrgtrgeyuwxkey")
    public suspend fun role(`value`: Output<Either<String, OpenShiftAgentPoolProfileRole>>) {
        this.role = value
    }

    /**
     * @param value Subnet CIDR for the peering.
     */
    @JvmName("hdqqxvoskepsegwc")
    public suspend fun subnetCidr(`value`: Output<String>) {
        this.subnetCidr = value
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("ffgvhrhfymfntiyq")
    public suspend fun vmSize(`value`: Output<Either<String, OpenShiftContainerServiceVMSize>>) {
        this.vmSize = value
    }

    /**
     * @param value Number of agents (VMs) to host docker containers.
     */
    @JvmName("usntnxtkmwvbljnb")
    public suspend fun count(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Unique name of the pool profile in the context of the subscription and resource group.
     */
    @JvmName("sqahktspiqyxwpor")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JvmName("goanqrcetxgotsna")
    public suspend fun osType(`value`: Either<String, OSType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JvmName("exurlgnixvwkcjen")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JvmName("orcqlxpgoqxkickx")
    public fun osType(`value`: OSType) {
        val toBeMapped = Either.ofRight<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Define the role of the AgentPoolProfile.
     */
    @JvmName("bpnarhmjrdydmmby")
    public suspend fun role(`value`: Either<String, OpenShiftAgentPoolProfileRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Define the role of the AgentPoolProfile.
     */
    @JvmName("qxtpyshtugjskemy")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OpenShiftAgentPoolProfileRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Define the role of the AgentPoolProfile.
     */
    @JvmName("qdlkgacjihmplpqj")
    public fun role(`value`: OpenShiftAgentPoolProfileRole) {
        val toBeMapped = Either.ofRight<String, OpenShiftAgentPoolProfileRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Subnet CIDR for the peering.
     */
    @JvmName("dhpxmlhcnrcugtub")
    public suspend fun subnetCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetCidr = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("lvvyffuaqgvffmyf")
    public suspend fun vmSize(`value`: Either<String, OpenShiftContainerServiceVMSize>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("ckfjpsjvrxheswvr")
    public fun vmSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OpenShiftContainerServiceVMSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("equbqfwhsefghpws")
    public fun vmSize(`value`: OpenShiftContainerServiceVMSize) {
        val toBeMapped = Either.ofRight<String, OpenShiftContainerServiceVMSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): OpenShiftManagedClusterAgentPoolProfileArgs =
        OpenShiftManagedClusterAgentPoolProfileArgs(
            count = count ?: throw PulumiNullFieldException("count"),
            name = name ?: throw PulumiNullFieldException("name"),
            osType = osType,
            role = role,
            subnetCidr = subnetCidr,
            vmSize = vmSize ?: throw PulumiNullFieldException("vmSize"),
        )
}
