@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftRouterProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an OpenShift router
 * @property name Name of the router profile.
 */
public data class OpenShiftRouterProfileArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftRouterProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.OpenShiftRouterProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftRouterProfileArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenShiftRouterProfileArgs].
 */
@PulumiTagMarker
public class OpenShiftRouterProfileArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the router profile.
     */
    @JvmName("plpirrnxnpmyyvjn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the router profile.
     */
    @JvmName("gpjynlqxvlgnocct")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): OpenShiftRouterProfileArgs = OpenShiftRouterProfileArgs(
        name = name,
    )
}
