@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.PrivateLinkResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A private link resource
 * @property groupId The group ID of the resource.
 * @property id The ID of the private link resource.
 * @property name The name of the private link resource.
 * @property requiredMembers The RequiredMembers of the resource
 * @property type The resource type.
 */
public data class PrivateLinkResourceArgs(
    public val groupId: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val requiredMembers: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.PrivateLinkResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.PrivateLinkResourceArgs =
        com.pulumi.azurenative.containerservice.inputs.PrivateLinkResourceArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requiredMembers(requiredMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkResourceArgs].
 */
@PulumiTagMarker
public class PrivateLinkResourceArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var requiredMembers: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The group ID of the resource.
     */
    @JvmName("lhvsjgbyjxskunhl")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The ID of the private link resource.
     */
    @JvmName("ximkunyptvesqjbs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the private link resource.
     */
    @JvmName("hfiuehthmhtqgupx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The RequiredMembers of the resource
     */
    @JvmName("cllrflnctgiorqrc")
    public suspend fun requiredMembers(`value`: Output<List<String>>) {
        this.requiredMembers = value
    }

    @JvmName("ibrstslbsmocnwfa")
    public suspend fun requiredMembers(vararg values: Output<String>) {
        this.requiredMembers = Output.all(values.asList())
    }

    /**
     * @param values The RequiredMembers of the resource
     */
    @JvmName("tulmwfsivpeecnyx")
    public suspend fun requiredMembers(values: List<Output<String>>) {
        this.requiredMembers = Output.all(values)
    }

    /**
     * @param value The resource type.
     */
    @JvmName("emabprienaiwsghe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The group ID of the resource.
     */
    @JvmName("krisnxxlecwsxqlf")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ID of the private link resource.
     */
    @JvmName("envmqvqdwcljpmdn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the private link resource.
     */
    @JvmName("baibdgasiesvtmki")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The RequiredMembers of the resource
     */
    @JvmName("bxiaekwacumvjtuy")
    public suspend fun requiredMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredMembers = mapped
    }

    /**
     * @param values The RequiredMembers of the resource
     */
    @JvmName("owxgpllfsxvqvwex")
    public suspend fun requiredMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredMembers = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("bwlsbhojqhrfvlmf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PrivateLinkResourceArgs = PrivateLinkResourceArgs(
        groupId = groupId,
        id = id,
        name = name,
        requiredMembers = requiredMembers,
        type = type,
    )
}
