@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the update sequence of the clusters via stages and groups.
 * Stages within a run are executed sequentially one after another.
 * Groups within a stage are executed in parallel.
 * Member clusters within a group are updated sequentially one after another.
 * A valid strategy contains no duplicate groups within or across stages.
 * @property stages The list of stages that compose this update run. Min size: 1.
 */
public data class UpdateRunStrategyArgs(
    public val stages: Output<List<UpdateStageArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs =
        com.pulumi.azurenative.containerservice.inputs.UpdateRunStrategyArgs.builder()
            .stages(
                stages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UpdateRunStrategyArgs].
 */
@PulumiTagMarker
public class UpdateRunStrategyArgsBuilder internal constructor() {
    private var stages: Output<List<UpdateStageArgs>>? = null

    /**
     * @param value The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("rejwlmjsbqbvlorr")
    public suspend fun stages(`value`: Output<List<UpdateStageArgs>>) {
        this.stages = value
    }

    @JvmName("qewcbawuvkeudrtv")
    public suspend fun stages(vararg values: Output<UpdateStageArgs>) {
        this.stages = Output.all(values.asList())
    }

    /**
     * @param values The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("gtilgxaqiknaaymh")
    public suspend fun stages(values: List<Output<UpdateStageArgs>>) {
        this.stages = Output.all(values)
    }

    /**
     * @param value The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("lrxlnubioejxribj")
    public suspend fun stages(`value`: List<UpdateStageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param argument The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("urtkmstkkesccvnu")
    public suspend fun stages(argument: List<suspend UpdateStageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { UpdateStageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("vexwqruhvhjiaujb")
    public suspend fun stages(vararg argument: suspend UpdateStageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { UpdateStageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("ycgeidawtwpkjkmn")
    public suspend fun stages(argument: suspend UpdateStageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UpdateStageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param values The list of stages that compose this update run. Min size: 1.
     */
    @JvmName("evdrkatgpcvaalib")
    public suspend fun stages(vararg values: UpdateStageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    internal fun build(): UpdateRunStrategyArgs = UpdateRunStrategyArgs(
        stages = stages ?: throw PulumiNullFieldException("stages"),
    )
}
