@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Profile of network configuration.
 * @property dnsServiceIP An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property ipFamilies IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
 * @property loadBalancerProfile Profile of the cluster load balancer.
 * @property loadBalancerSku The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
 * @property natGatewayProfile Profile of the cluster NAT gateway.
 * @property networkDataplane Network dataplane used in the Kubernetes cluster.
 * @property networkMode This cannot be specified if networkPlugin is anything other than 'azure'.
 * @property networkPlugin Network plugin used for building the Kubernetes network.
 * @property networkPluginMode The mode the network plugin should use.
 * @property networkPolicy Network policy used for building the Kubernetes network.
 * @property outboundType This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
 * @property podCidr A CIDR notation IP range from which to assign pod IPs when kubenet is used.
 * @property podCidrs One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidr A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property serviceCidrs One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
 */
public data class ContainerServiceNetworkProfileResponse(
    public val dnsServiceIP: String? = null,
    public val ipFamilies: List<String>? = null,
    public val loadBalancerProfile: ManagedClusterLoadBalancerProfileResponse? = null,
    public val loadBalancerSku: String? = null,
    public val natGatewayProfile: ManagedClusterNATGatewayProfileResponse? = null,
    public val networkDataplane: String? = null,
    public val networkMode: String? = null,
    public val networkPlugin: String? = null,
    public val networkPluginMode: String? = null,
    public val networkPolicy: String? = null,
    public val outboundType: String? = null,
    public val podCidr: String? = null,
    public val podCidrs: List<String>? = null,
    public val serviceCidr: String? = null,
    public val serviceCidrs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ContainerServiceNetworkProfileResponse): ContainerServiceNetworkProfileResponse = ContainerServiceNetworkProfileResponse(
            dnsServiceIP = javaType.dnsServiceIP().map({ args0 -> args0 }).orElse(null),
            ipFamilies = javaType.ipFamilies().map({ args0 -> args0 }),
            loadBalancerProfile = javaType.loadBalancerProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterLoadBalancerProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loadBalancerSku = javaType.loadBalancerSku().map({ args0 -> args0 }).orElse(null),
            natGatewayProfile = javaType.natGatewayProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterNATGatewayProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkDataplane = javaType.networkDataplane().map({ args0 -> args0 }).orElse(null),
            networkMode = javaType.networkMode().map({ args0 -> args0 }).orElse(null),
            networkPlugin = javaType.networkPlugin().map({ args0 -> args0 }).orElse(null),
            networkPluginMode = javaType.networkPluginMode().map({ args0 -> args0 }).orElse(null),
            networkPolicy = javaType.networkPolicy().map({ args0 -> args0 }).orElse(null),
            outboundType = javaType.outboundType().map({ args0 -> args0 }).orElse(null),
            podCidr = javaType.podCidr().map({ args0 -> args0 }).orElse(null),
            podCidrs = javaType.podCidrs().map({ args0 -> args0 }),
            serviceCidr = javaType.serviceCidr().map({ args0 -> args0 }).orElse(null),
            serviceCidrs = javaType.serviceCidrs().map({ args0 -> args0 }),
        )
    }
}
