@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data used when creating a target resource from a source resource.
 * @property sourceResourceId This is the ARM ID of the source object to be used to create the target object.
 */
public data class CreationDataResponse(
    public val sourceResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.CreationDataResponse): CreationDataResponse = CreationDataResponse(
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
