@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The FleetHubProfile configures the fleet hub.
 * @property dnsPrefix DNS prefix used to create the FQDN for the Fleet hub.
 * @property fqdn The FQDN of the Fleet hub.
 * @property kubernetesVersion The Kubernetes version of the Fleet hub.
 */
public data class FleetHubProfileResponse(
    public val dnsPrefix: String? = null,
    public val fqdn: String,
    public val kubernetesVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.FleetHubProfileResponse): FleetHubProfileResponse = FleetHubProfileResponse(
            dnsPrefix = javaType.dnsPrefix().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            kubernetesVersion = javaType.kubernetesVersion(),
        )
    }
}
