@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The configurations regarding multiple standard load balancers. If not supplied, single load balancer mode will be used. Multiple standard load balancers mode will be used if at lease one configuration is supplied. There has to be a configuration named `kubernetes`.
 * @property allowServicePlacement Whether to automatically place services on the load balancer. If not supplied, the default value is true. If set to false manually, both of the external and the internal load balancer will not be selected for services unless they explicitly target it.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property nodeSelector Nodes that match this selector will be possible members of this load balancer.
 * @property primaryAgentPoolName Required field. A string value that must specify the ID of an existing agent pool. All nodes in the given pool will always be added to this load balancer. This agent pool must have at least one node and minCount>=1 for autoscaling operations. An agent pool can only be the primary pool for a single load balancer.
 * @property provisioningState The current provisioning state.
 * @property serviceLabelSelector Only services that must match this selector can be placed on this load balancer.
 * @property serviceNamespaceSelector Services created in namespaces that match the selector can be placed on this load balancer.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLoadBalancerResult(
    public val allowServicePlacement: Boolean? = null,
    public val id: String,
    public val name: String,
    public val nodeSelector: LabelSelectorResponse? = null,
    public val primaryAgentPoolName: String,
    public val provisioningState: String,
    public val serviceLabelSelector: LabelSelectorResponse? = null,
    public val serviceNamespaceSelector: LabelSelectorResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetLoadBalancerResult): GetLoadBalancerResult = GetLoadBalancerResult(
            allowServicePlacement = javaType.allowServicePlacement().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            nodeSelector = javaType.nodeSelector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryAgentPoolName = javaType.primaryAgentPoolName(),
            provisioningState = javaType.provisioningState(),
            serviceLabelSelector = javaType.serviceLabelSelector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceNamespaceSelector = javaType.serviceNamespaceSelector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
