@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property notAllowedTime Time slots on which upgrade is not allowed.
 * @property systemData The system metadata relating to this resource.
 * @property timeInWeek If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
 * @property type Resource type
 */
public data class GetMaintenanceConfigurationResult(
    public val id: String,
    public val name: String,
    public val notAllowedTime: List<TimeSpanResponse>? = null,
    public val systemData: SystemDataResponse,
    public val timeInWeek: List<TimeInWeekResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetMaintenanceConfigurationResult): GetMaintenanceConfigurationResult = GetMaintenanceConfigurationResult(
            id = javaType.id(),
            name = javaType.name(),
            notAllowedTime = javaType.notAllowedTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.TimeSpanResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeInWeek = javaType.timeInWeek().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.TimeInWeekResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
