@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Managed cluster.
 * @property aadProfile The Azure Active Directory configuration.
 * @property addonProfiles The profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pool properties.
 * @property apiServerAccessProfile The access profile for managed cluster API server.
 * @property autoScalerProfile Parameters to be applied to the cluster-autoscaler when enabled
 * @property autoUpgradeProfile The auto upgrade configuration.
 * @property azureMonitorProfile Azure Monitor addon profiles for monitoring the managed cluster.
 * @property azurePortalFQDN The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
 * @property currentKubernetesVersion If kubernetesVersion was a fully specified version <major.minor.patch>, this field will be exactly equal to it. If kubernetesVersion was <major.minor>, this field will contain the full <major.minor.patch> version being used.
 * @property disableLocalAccounts If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
 * @property diskEncryptionSetID This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
 * @property dnsPrefix This cannot be updated once the Managed Cluster has been created.
 * @property enablePodSecurityPolicy (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
 * @property enableRBAC Whether to enable Kubernetes Role-Based Access Control.
 * @property extendedLocation The extended location of the Virtual Machine.
 * @property fqdn The FQDN of the master pool.
 * @property fqdnSubdomain This cannot be updated once the Managed Cluster has been created.
 * @property httpProxyConfig Configurations for provisioning the cluster with HTTP proxy servers.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the managed cluster, if configured.
 * @property identityProfile Identities associated with the cluster.
 * @property kubernetesVersion Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
 * @property linuxProfile The profile for Linux VMs in the Managed Cluster.
 * @property location The geo-location where the resource lives
 * @property maxAgentPools The max number of agent pools for the managed cluster.
 * @property name The name of the resource
 * @property networkProfile The network configuration profile.
 * @property nodeResourceGroup The name of the resource group containing agent pool nodes.
 * @property oidcIssuerProfile The OIDC issuer profile of the Managed Cluster.
 * @property podIdentityProfile See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
 * @property powerState The Power State of the cluster.
 * @property privateFQDN The FQDN of private cluster.
 * @property privateLinkResources Private link resources associated with the cluster.
 * @property provisioningState The current provisioning state.
 * @property publicNetworkAccess Allow or deny public network access for AKS
 * @property securityProfile Security profile for the managed cluster.
 * @property servicePrincipalProfile Information about a service principal identity for the cluster to use for manipulating Azure APIs.
 * @property sku The managed cluster SKU.
 * @property storageProfile Storage profile for the managed cluster.
 * @property supportPlan The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property windowsProfile The profile for Windows VMs in the Managed Cluster.
 * @property workloadAutoScalerProfile Workload Auto-scaler profile for the managed cluster.
 */
public data class GetManagedClusterResult(
    public val aadProfile: ManagedClusterAADProfileResponse? = null,
    public val addonProfiles: Map<String, ManagedClusterAddonProfileResponse>? = null,
    public val agentPoolProfiles: List<ManagedClusterAgentPoolProfileResponse>? = null,
    public val apiServerAccessProfile: ManagedClusterAPIServerAccessProfileResponse? = null,
    public val autoScalerProfile: ManagedClusterPropertiesResponseAutoScalerProfile? = null,
    public val autoUpgradeProfile: ManagedClusterAutoUpgradeProfileResponse? = null,
    public val azureMonitorProfile: ManagedClusterAzureMonitorProfileResponse? = null,
    public val azurePortalFQDN: String,
    public val currentKubernetesVersion: String,
    public val disableLocalAccounts: Boolean? = null,
    public val diskEncryptionSetID: String? = null,
    public val dnsPrefix: String? = null,
    public val enablePodSecurityPolicy: Boolean? = null,
    public val enableRBAC: Boolean? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val fqdn: String,
    public val fqdnSubdomain: String? = null,
    public val httpProxyConfig: ManagedClusterHTTPProxyConfigResponse? = null,
    public val id: String,
    public val identity: ManagedClusterIdentityResponse? = null,
    public val identityProfile: Map<String, UserAssignedIdentityResponse>? = null,
    public val kubernetesVersion: String? = null,
    public val linuxProfile: ContainerServiceLinuxProfileResponse? = null,
    public val location: String,
    public val maxAgentPools: Int,
    public val name: String,
    public val networkProfile: ContainerServiceNetworkProfileResponse? = null,
    public val nodeResourceGroup: String? = null,
    public val oidcIssuerProfile: ManagedClusterOIDCIssuerProfileResponse? = null,
    public val podIdentityProfile: ManagedClusterPodIdentityProfileResponse? = null,
    public val powerState: PowerStateResponse,
    public val privateFQDN: String,
    public val privateLinkResources: List<PrivateLinkResourceResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val securityProfile: ManagedClusterSecurityProfileResponse? = null,
    public val servicePrincipalProfile: ManagedClusterServicePrincipalProfileResponse? = null,
    public val sku: ManagedClusterSKUResponse? = null,
    public val storageProfile: ManagedClusterStorageProfileResponse? = null,
    public val supportPlan: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val windowsProfile: ManagedClusterWindowsProfileResponse? = null,
    public val workloadAutoScalerProfile: ManagedClusterWorkloadAutoScalerProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetManagedClusterResult): GetManagedClusterResult = GetManagedClusterResult(
            aadProfile = javaType.aadProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAADProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            addonProfiles = javaType.addonProfiles().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAddonProfileResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            agentPoolProfiles = javaType.agentPoolProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAgentPoolProfileResponse.Companion.toKotlin(args0)
                })
            }),
            apiServerAccessProfile = javaType.apiServerAccessProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAPIServerAccessProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoScalerProfile = javaType.autoScalerProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPropertiesResponseAutoScalerProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoUpgradeProfile = javaType.autoUpgradeProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAutoUpgradeProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureMonitorProfile = javaType.azureMonitorProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAzureMonitorProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azurePortalFQDN = javaType.azurePortalFQDN(),
            currentKubernetesVersion = javaType.currentKubernetesVersion(),
            disableLocalAccounts = javaType.disableLocalAccounts().map({ args0 -> args0 }).orElse(null),
            diskEncryptionSetID = javaType.diskEncryptionSetID().map({ args0 -> args0 }).orElse(null),
            dnsPrefix = javaType.dnsPrefix().map({ args0 -> args0 }).orElse(null),
            enablePodSecurityPolicy = javaType.enablePodSecurityPolicy().map({ args0 -> args0 }).orElse(null),
            enableRBAC = javaType.enableRBAC().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fqdn = javaType.fqdn(),
            fqdnSubdomain = javaType.fqdnSubdomain().map({ args0 -> args0 }).orElse(null),
            httpProxyConfig = javaType.httpProxyConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterHTTPProxyConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identityProfile = javaType.identityProfile().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            kubernetesVersion = javaType.kubernetesVersion().map({ args0 -> args0 }).orElse(null),
            linuxProfile = javaType.linuxProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceLinuxProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            maxAgentPools = javaType.maxAgentPools(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodeResourceGroup = javaType.nodeResourceGroup().map({ args0 -> args0 }).orElse(null),
            oidcIssuerProfile = javaType.oidcIssuerProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterOIDCIssuerProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            podIdentityProfile = javaType.podIdentityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse.Companion.toKotlin(args0)
            }),
            privateFQDN = javaType.privateFQDN(),
            privateLinkResources = javaType.privateLinkResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.PrivateLinkResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            servicePrincipalProfile = javaType.servicePrincipalProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterServicePrincipalProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSKUResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportPlan = javaType.supportPlan().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            windowsProfile = javaType.windowsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWindowsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workloadAutoScalerProfile = javaType.workloadAutoScalerProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWorkloadAutoScalerProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
