@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection
 * @property id The ID of the private endpoint connection.
 * @property name The name of the private endpoint connection.
 * @property privateEndpoint The resource of private endpoint.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property provisioningState The current provisioning state.
 * @property type The resource type.
 */
public data class GetPrivateEndpointConnectionResult(
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
